/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.controller;

import com.xforceplus.ultraman.oqsengine.sdk.service.EntityServiceEx;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.DictItem;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.Response;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ResponseList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping
public class DictController {
    @Autowired
    private EntityServiceEx entityServiceEx;

    @GetMapping(value={"/enum/{id}/options"})
    @ResponseBody
    public Response getDict(@PathVariable(value="id") String enumId, @RequestParam(required=false) String enumCode) {
        Response<ResponseList> response = new Response<ResponseList>();
        List<DictItem> dictItems = this.entityServiceEx.findDictItems(enumId, enumCode);
        if (dictItems.size() > 0) {
            response.setMessage("\u67e5\u8be2\u6210\u529f");
            response.setCode("200");
            response.setResult((ResponseList)dictItems);
        } else {
            response.setMessage("\u67e5\u8be2\u65e0\u7ed3\u679c");
            response.setCode("500");
        }
        return response;
    }

    @GetMapping(value={"/enums/options"})
    @ResponseBody
    public Response getDicts(@RequestParam(required=false, value="ids") String[] enumIds) {
        Response response = new Response();
        if (enumIds != null && enumIds.length > 0) {
            HashMap<String, List<DictItem>> enums = new HashMap<String, List<DictItem>>();
            for (String enumId : enumIds) {
                List<DictItem> dictItems = this.entityServiceEx.findDictItems(enumId, null);
                enums.put(enumId, dictItems);
            }
            if (enums.size() > 0) {
                response.setMessage("\u67e5\u8be2\u6210\u529f");
                response.setCode("1");
                response.setResult(enums);
            } else {
                response.setMessage("\u67e5\u8be2\u65e0\u7ed3\u679c");
                response.setCode("-1");
            }
        } else {
            response.setMessage("\u8bf7\u4f20\u5165\u9700\u8981\u67e5\u8be2\u7684\u5b57\u5178id");
            response.setCode("-1");
        }
        return response;
    }
}

