/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.controller;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.sdk.config.AuthSearcherConfig;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.MetadataRepository;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.BoInfoVo;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.BoItem;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.Response;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping
public class ModuleController {
    @Autowired
    private MetadataRepository metadataRepository;
    @Autowired
    private AuthSearcherConfig config;

    @GetMapping(value={"/bos/{id}/entityClass"})
    @ResponseBody
    public Response<BoItem> getBoDetails(@PathVariable String id) {
        Response<BoItem> response = new Response<BoItem>();
        BoItem boItem = this.metadataRepository.getBoDetailById(id);
        if (boItem != null) {
            response.setCode("1");
            response.setMessage("\u83b7\u53d6\u6210\u529f");
            response.setResult(boItem);
        } else {
            response.setCode("-1");
            response.setMessage("\u4e0d\u5b58\u5728\u8be5\u5bf9\u8c61");
        }
        return response;
    }

    @GetMapping(value={"/bos/entityClasses"})
    @ResponseBody
    public Response<List<String>> getAllBoDetails() {
        Response<List<String>> response = new Response<List<String>>();
        List<IEntityClass> allEntities = this.metadataRepository.findAllEntities();
        response.setCode("1");
        response.setMessage("\u83b7\u53d6\u6210\u529f");
        response.setResult(allEntities.stream().map(Object::toString).collect(Collectors.toList()));
        return response;
    }

    @GetMapping(value={"/bos/entityClass/{id}"})
    @ResponseBody
    public Response<String> getEntityClassById(@PathVariable Long id) {
        Optional<IEntityClass> load = this.metadataRepository.load(this.config.getTenant(), this.config.getAppId(), id.toString());
        return load.map(entity -> {
            Response<String> response = new Response<String>();
            response.setCode("1");
            response.setMessage("\u83b7\u53d6\u6210\u529f");
            response.setResult(entity.toString());
            return response;
        }).orElseThrow(() -> new RuntimeException("NOT found"));
    }

    @GetMapping(value={"/bos/entityClass/code/{code}"})
    @ResponseBody
    public Response<String> getEntityClassByCode(@PathVariable String code) {
        Optional<IEntityClass> load = this.metadataRepository.loadByCode(this.config.getTenant(), this.config.getAppId(), code);
        return load.map(entity -> {
            Response<String> response = new Response<String>();
            response.setCode("1");
            response.setMessage("\u83b7\u53d6\u6210\u529f");
            response.setResult(entity.toString());
            return response;
        }).orElseThrow(() -> new RuntimeException("NOT found"));
    }

    @GetMapping(value={"/bos/entityClass/domain-root"})
    @ResponseBody
    public Response<List<BoInfoVo>> getAllDomainRoot() {
        List boList = this.metadataRepository.loadBoList().stream().filter(x -> x.getRootFlag() != null && x.getRootFlag().equals("1")).collect(Collectors.toList());
        Response<List<BoInfoVo>> response = new Response<List<BoInfoVo>>();
        response.setCode("1");
        response.setMessage("\u83b7\u53d6\u6210\u529f");
        response.setResult(boList);
        return response;
    }
}

