/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.impl;

import akka.grpc.javadsl.SingleResponseRequestBuilder;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.EntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.Record;
import com.xforceplus.ultraman.oqsengine.sdk.ConditionsUp;
import com.xforceplus.ultraman.oqsengine.sdk.EntityServiceClient;
import com.xforceplus.ultraman.oqsengine.sdk.EntityUp;
import com.xforceplus.ultraman.oqsengine.sdk.OperationResult;
import com.xforceplus.ultraman.oqsengine.sdk.SelectByCondition;
import com.xforceplus.ultraman.oqsengine.sdk.ValueUp;
import com.xforceplus.ultraman.oqsengine.sdk.event.EntityCreated;
import com.xforceplus.ultraman.oqsengine.sdk.event.EntityDeleted;
import com.xforceplus.ultraman.oqsengine.sdk.event.EntityUpdated;
import com.xforceplus.ultraman.oqsengine.sdk.service.EntityService;
import com.xforceplus.ultraman.oqsengine.sdk.service.HandleQueryValueService;
import com.xforceplus.ultraman.oqsengine.sdk.service.HandleResultValueService;
import com.xforceplus.ultraman.oqsengine.sdk.service.HandleValueService;
import com.xforceplus.ultraman.oqsengine.sdk.service.OperationType;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.MetadataRepository;
import com.xforceplus.ultraman.oqsengine.sdk.transactional.OqsTransactionManager;
import com.xforceplus.ultraman.oqsengine.sdk.transactional.annotation.Propagation;
import com.xforceplus.ultraman.oqsengine.sdk.util.ConditionQueryRequestHelper;
import com.xforceplus.ultraman.oqsengine.sdk.util.EntityClassToGrpcConverter;
import com.xforceplus.ultraman.oqsengine.sdk.util.context.ContextDecorator;
import com.xforceplus.ultraman.oqsengine.sdk.util.flow.FlowRegistry;
import com.xforceplus.ultraman.oqsengine.sdk.util.flow.QueueFlow;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.Conditions;
import com.xforceplus.xplat.galaxy.framework.context.ContextKeys;
import com.xforceplus.xplat.galaxy.framework.context.ContextService;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.RetryRegistry;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.util.StringUtils;

public class EntityServiceImpl
implements EntityService,
InitializingBean {
    private final MetadataRepository metadataRepository;
    private final EntityServiceClient entityServiceClient;
    private final ContextService contextService;
    @Autowired
    private ApplicationEventPublisher publisher;
    @Autowired
    private HandleValueService handlerValueService;
    @Autowired
    private HandleQueryValueService handleQueryValueService;
    @Autowired
    private HandleResultValueService handleResultValueService;
    @Autowired
    private RetryRegistry retryRegistry;
    @Autowired
    private FlowRegistry flowRegistry;
    private RetryConfig retryConfig;
    @Value(value="${xplat.oqsengine.sdk.cas.retry.max-attempts:10}")
    private int maxAttempts;
    @Value(value="${xplat.oqsengine.sdk.cas.retry.delay:100}")
    private int delay;
    @Value(value="${xplat.oqsengine.sdk.strict.range:true}")
    private boolean isRangeStrict;
    @Value(value="${xplat.oqsengine.sdk.strict.force-delete:true}")
    private boolean isForce;
    @Value(value="${xplat.oqsengine.sdk.transaction.timeout:-1}")
    private Integer timeout;
    @Autowired
    private OqsTransactionManager oqsTransactionManager;
    private Logger logger = LoggerFactory.getLogger(EntityService.class);

    public EntityServiceImpl(MetadataRepository metadataRepository, EntityServiceClient entityServiceClient, ContextService contextService) {
        this.metadataRepository = metadataRepository;
        this.entityServiceClient = entityServiceClient;
        this.contextService = contextService;
    }

    @Override
    public Optional<IEntityClass> load(String boId) {
        String tenantId = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTID_KEY);
        String appCode = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.APPCODE);
        return this.metadataRepository.load(tenantId, appCode, boId);
    }

    @Override
    public Optional<IEntityClass> load(String boId, String version) {
        String tenantId = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTID_KEY);
        String appCode = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.APPCODE);
        return this.metadataRepository.load(tenantId, appCode, boId, version);
    }

    @Override
    public Optional<IEntityClass> loadByCode(String bocode) {
        String tenantId = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTID_KEY);
        String appCode = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.APPCODE);
        return this.metadataRepository.loadByCode(tenantId, appCode, bocode);
    }

    @Override
    public Optional<IEntityClass> loadByCode(String bocode, String version) {
        String tenantId = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTID_KEY);
        String appCode = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.APPCODE);
        return this.metadataRepository.loadByCode(tenantId, appCode, bocode, version);
    }

    @Override
    public <T> Either<String, T> transactionalExecute(Callable<T> supplier) {
        try {
            T result = this.oqsTransactionManager.transactionExecution(Propagation.REQUIRES_NEW, this.timeout, null, null, supplier);
            return Either.right(result);
        }
        catch (Throwable throwable) {
            return Either.left((Object)throwable.getMessage());
        }
    }

    @Override
    public Either<String, Map<String, Object>> findOne(IEntityClass entityClass, long id) {
        String transId = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY);
        SingleResponseRequestBuilder queryResultBuilder = this.entityServiceClient.selectOne();
        if (transId != null) {
            this.logger.info("Query with Transaction id:{} ", (Object)transId);
            queryResultBuilder = queryResultBuilder.addHeader("transaction-id", transId);
        } else {
            this.logger.debug("Query without Transaction");
        }
        OperationResult queryResult = (OperationResult)queryResultBuilder.invoke((Object)EntityClassToGrpcConverter.toEntityUp(entityClass, id)).toCompletableFuture().join();
        if (queryResult.getCode() == OperationResult.Code.OK) {
            if (queryResult.getTotalRow() > 0) {
                return Either.right((Object)this.handleResultValueService.toRecord(entityClass, (EntityUp)queryResult.getQueryResultList().get(0)).toMap(null));
            }
            return Either.left((Object)"\u672a\u67e5\u8be2\u5230\u8bb0\u5f55");
        }
        return Either.left((Object)queryResult.getMessage());
    }

    @Override
    public <T> Either<String, T> retryExecute(String key, Supplier<Either<String, T>> supplier) {
        QueueFlow queueFlow = this.flowRegistry.flow(key);
        CompletableFuture future = new CompletableFuture();
        Retry retry = this.retryRegistry.retry("retry-" + UUID.randomUUID().toString(), this.retryConfig);
        retry.getEventPublisher().onRetry(retryEvt -> this.logger.info("Trigger Retry {} attempts {} left {}", new Object[]{retryEvt.getName(), retryEvt.getNumberOfRetryAttempts(), this.maxAttempts - retryEvt.getNumberOfRetryAttempts()}));
        queueFlow.feed(Tuple.of(future, (Object)Retry.decorateSupplier((Retry)retry, ContextDecorator.decorateSupplier(this.contextService, supplier))));
        return (Either)future.join();
    }

    public Either<String, Integer> optimizeDeleteOne(IEntityClass entityClass, Long id) {
        OperationResult updateResult;
        String transId = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY);
        SingleResponseRequestBuilder removeBuilder = this.entityServiceClient.remove();
        if (transId != null) {
            this.logger.info("delete with Transaction id:{} ", (Object)transId);
            removeBuilder = removeBuilder.addHeader("transaction-id", transId);
        }
        String userDisplayName = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.USER_DISPLAYNAME);
        String userName = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.USERNAME);
        if (userDisplayName != null) {
            removeBuilder = removeBuilder.addHeader("display-name", userDisplayName);
        }
        if (userName != null) {
            removeBuilder = removeBuilder.addHeader("username", userDisplayName);
        }
        if ((updateResult = (OperationResult)removeBuilder.invoke((Object)EntityClassToGrpcConverter.toEntityUp(entityClass, id)).toCompletableFuture().join()).getCode() == OperationResult.Code.OK) {
            int rows = updateResult.getAffectedRow();
            if (rows > 0) {
                this.publisher.publishEvent((Object)this.buildDeleteEvent(entityClass, id));
            }
            return Either.right((Object)rows);
        }
        return Either.left((Object)updateResult.getMessage());
    }

    @Override
    public Either<String, Integer> deleteOne(IEntityClass entityClass, Long id) {
        OperationResult updateResult;
        String transId = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY);
        SingleResponseRequestBuilder removeBuilder = this.entityServiceClient.remove();
        if (transId != null) {
            this.logger.info("delete with Transaction id:{} ", (Object)transId);
            removeBuilder = removeBuilder.addHeader("transaction-id", transId);
        }
        String userDisplayName = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.USER_DISPLAYNAME);
        String userName = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.USERNAME);
        if (userDisplayName != null) {
            removeBuilder = removeBuilder.addHeader("display-name", userDisplayName);
        }
        if (userName != null) {
            removeBuilder = removeBuilder.addHeader("username", userDisplayName);
        }
        if (this.isForce) {
            removeBuilder = removeBuilder.addHeader("force", "true");
        }
        if ((updateResult = (OperationResult)removeBuilder.invoke((Object)EntityClassToGrpcConverter.toEntityUp(entityClass, id)).toCompletableFuture().join()).getCode() == OperationResult.Code.OK) {
            int rows = updateResult.getAffectedRow();
            if (rows > 0) {
                this.publisher.publishEvent((Object)this.buildDeleteEvent(entityClass, id));
            }
            return Either.right((Object)rows);
        }
        return Either.left((Object)updateResult.getMessage());
    }

    private Map<String, String> getContext() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(ContextKeys.StringKeys.TENANTID_KEY.name(), (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTID_KEY));
        map.put(ContextKeys.StringKeys.TENANTCODE_KEY.name(), (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTCODE_KEY));
        map.put(ContextKeys.StringKeys.USERNAME.name(), (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.USERNAME));
        map.put(ContextKeys.StringKeys.USER_DISPLAYNAME.name(), (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.USER_DISPLAYNAME));
        return map;
    }

    @Override
    public Either<String, Integer> updateById(IEntityClass entityClass, Long id, Map<String, Object> body) {
        List<ValueUp> valueUps;
        OperationResult updateResult;
        String transId = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY);
        SingleResponseRequestBuilder replaceBuilder = this.entityServiceClient.replace();
        if (transId != null) {
            this.logger.info("updateById with Transaction id:{} ", (Object)transId);
            replaceBuilder = replaceBuilder.addHeader("transaction-id", transId);
        }
        if ((updateResult = (OperationResult)replaceBuilder.invoke((Object)EntityClassToGrpcConverter.toEntityUp(entityClass, id, valueUps = this.handlerValueService.handlerValue(entityClass, body, OperationType.UPDATE))).toCompletableFuture().join()).getCode() == OperationResult.Code.OK) {
            int rows = updateResult.getAffectedRow();
            if (rows > 0) {
                this.publisher.publishEvent((Object)this.buildUpdatedEvent(entityClass, id, body));
            }
            return Either.right((Object)rows);
        }
        return Either.left((Object)updateResult.getMessage());
    }

    @Override
    public Either<String, Integer> updateByCondition(IEntityClass entityClass, ConditionQueryRequest condition, Map<String, Object> body) {
        ConditionsUp conditionsUp;
        List<ValueUp> valueUps;
        SelectByCondition sbc;
        OperationResult updateResult;
        String transId = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY);
        SingleResponseRequestBuilder requestBuilder = this.entityServiceClient.replaceByCondition();
        if (transId != null) {
            this.logger.info("updateByCondition with Transaction id:{} ", (Object)transId);
            requestBuilder = requestBuilder.addHeader("transaction-id", transId);
        }
        if ((updateResult = (OperationResult)requestBuilder.invoke((Object)(sbc = EntityClassToGrpcConverter.toUpdateSelection(entityClass, () -> EntityServiceImpl.lambda$updateByCondition$3(entityClass, valueUps = this.handlerValueService.handlerValue(entityClass, body, OperationType.UPDATE)), condition, conditionsUp = Optional.ofNullable(condition).map(ConditionQueryRequest::getConditions).map(x -> this.handleQueryValueService.handleQueryValue(entityClass, condition.getConditions(), OperationType.QUERY)).orElseGet(() -> ConditionsUp.newBuilder().build())))).toCompletableFuture().join()).getCode() == OperationResult.Code.OK) {
            int rows = updateResult.getAffectedRow();
            if (rows > 0) {
                updateResult.getIdsList().forEach(x -> this.publisher.publishEvent((Object)this.buildUpdatedEvent(entityClass, (Long)x, body)));
            }
            return Either.right((Object)rows);
        }
        return Either.left((Object)updateResult.getMessage());
    }

    @Override
    public Either<String, Integer> replaceById(IEntityClass entityClass, Long id, Map<String, Object> body) {
        List<ValueUp> valueUps;
        OperationResult updateResult;
        String transId = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY);
        SingleResponseRequestBuilder replaceBuilder = this.entityServiceClient.replace();
        if (transId != null) {
            this.logger.info("replaceById with Transaction id:{} ", (Object)transId);
            replaceBuilder = replaceBuilder.addHeader("transaction-id", transId);
        }
        if ((updateResult = (OperationResult)(replaceBuilder = replaceBuilder.addHeader("mode", "replace")).invoke((Object)EntityClassToGrpcConverter.toEntityUp(entityClass, id, valueUps = this.handlerValueService.handlerValue(entityClass, body, OperationType.REPLACE))).toCompletableFuture().join()).getCode() == OperationResult.Code.OK) {
            int rows = updateResult.getAffectedRow();
            if (rows > 0) {
                this.publisher.publishEvent((Object)this.buildUpdatedEvent(entityClass, id, body));
            }
            return Either.right((Object)rows);
        }
        return Either.left((Object)updateResult.getMessage());
    }

    @Override
    public Either<String, Tuple2<Integer, List<Record>>> findRecordsByCondition(IEntityClass entityClass, List<Long> ids, ConditionQueryRequest condition) {
        ConditionsUp conditionsUp;
        OperationResult result;
        String transId = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY);
        SingleResponseRequestBuilder requestBuilder = this.entityServiceClient.selectByConditions();
        ConditionQueryRequest finalRequest = ConditionQueryRequestHelper.build(ids, condition);
        if (this.isRangeStrict) {
            boolean noRange;
            boolean bl = noRange = finalRequest.getPageSize() == null || finalRequest.getPageNo() == null;
            if (noRange) {
                return Either.left((Object)"[STRICT-MODE]: RangeSearch Without Range");
            }
        }
        if (transId != null) {
            this.logger.info("findRecordsByCondition with Transaction id:{} ", (Object)transId);
            requestBuilder = requestBuilder.addHeader("transaction-id", transId);
        }
        if ((result = (OperationResult)requestBuilder.invoke((Object)EntityClassToGrpcConverter.toSelectByCondition(entityClass, finalRequest, conditionsUp = Optional.ofNullable(finalRequest).map(ConditionQueryRequest::getConditions).map(x -> this.handleQueryValueService.handleQueryValue(entityClass, (Conditions)x, OperationType.QUERY)).orElseGet(() -> ConditionsUp.newBuilder().build()))).toCompletableFuture().join()).getCode() == OperationResult.Code.OK) {
            List repList = result.getQueryResultList().stream().map(x -> this.handleResultValueService.toRecord(entityClass, (EntityUp)x)).collect(Collectors.toList());
            Tuple2 queryResult = Tuple.of((Object)result.getTotalRow(), repList);
            return Either.right((Object)queryResult);
        }
        return Either.left((Object)result.getMessage());
    }

    @Override
    public Either<String, Tuple2<Integer, List<Map<String, Object>>>> findByCondition(IEntityClass entityClass, ConditionQueryRequest condition) {
        return this.findByConditionWithIds(entityClass, null, condition);
    }

    @Override
    public Either<String, Tuple2<Integer, List<Map<String, Object>>>> findByConditionWithIds(IEntityClass entityClass, List<Long> ids, ConditionQueryRequest condition) {
        return this.findRecordsByCondition(entityClass, ids, condition).map(tuple -> {
            List mapResult = ((List)tuple._2()).stream().map(record -> record.toMap(Optional.ofNullable(condition).map(ConditionQueryRequest::getStringKeys).orElseGet(Collections::emptySet))).collect(Collectors.toList());
            return Tuple.of((Object)tuple._1(), mapResult);
        });
    }

    @Override
    public Either<String, Long> create(IEntityClass entityClass, Map<String, Object> body) {
        List<ValueUp> valueUps;
        OperationResult createResult;
        String transId = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY);
        SingleResponseRequestBuilder buildBuilder = this.entityServiceClient.build();
        if (transId != null) {
            this.logger.info("create with Transaction id:{} ", (Object)transId);
            buildBuilder = buildBuilder.addHeader("transaction-id", transId);
        }
        if ((createResult = (OperationResult)buildBuilder.invoke((Object)EntityClassToGrpcConverter.toEntityUp(entityClass, null, valueUps = this.handlerValueService.handlerValue(entityClass, body, OperationType.CREATE))).toCompletableFuture().join()).getCode() == OperationResult.Code.OK) {
            if (createResult.getIdsList().size() < 1) {
                return Either.left((Object)"\u672a\u83b7\u5f97\u7ed3\u679c");
            }
            Long id = (Long)createResult.getIdsList().get(0);
            this.publisher.publishEvent((Object)this.buildCreatedEvent(entityClass, id, body));
            return Either.right((Object)id);
        }
        return Either.left((Object)createResult.getMessage());
    }

    @Override
    public Integer count(IEntityClass entityClass, ConditionQueryRequest condition) {
        OperationResult result;
        String transId = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY);
        SingleResponseRequestBuilder requestBuilder = this.entityServiceClient.selectByConditions();
        if (transId != null) {
            this.logger.info("count with Transaction id:{} ", (Object)transId);
            requestBuilder = requestBuilder.addHeader("transaction-id", transId);
        }
        if ((result = (OperationResult)requestBuilder.invoke((Object)EntityClassToGrpcConverter.toSelectByCondition(entityClass, null, condition)).toCompletableFuture().join()).getCode() == OperationResult.Code.OK) {
            return result.getTotalRow();
        }
        return 0;
    }

    @Override
    public List<IEntityClass> loadSonByCode(String bocode, String tenantId) {
        return this.loadSonByCode(bocode, tenantId, null);
    }

    @Override
    public List<IEntityClass> loadSonByCode(String bocode, String tenantId, String version) {
        if (StringUtils.isEmpty((Object)tenantId)) {
            tenantId = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTID_KEY);
        }
        String appCode = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.APPCODE);
        if (version == null) {
            return this.metadataRepository.findSubEntitiesByCode(tenantId, appCode, bocode);
        }
        return this.metadataRepository.findSubEntitiesByCode(tenantId, appCode, bocode, version);
    }

    @Override
    public List<IEntityClass> getEntityClasss() {
        return this.metadataRepository.findAllEntities();
    }

    @Override
    public List<IEntityClass> loadDomainRootEntityClass() {
        return null;
    }

    @Override
    public List<IEntityClass> loadDomainEntityClass(EntityClass domainEntityClass) {
        return null;
    }

    private EntityDeleted buildDeleteEvent(IEntityClass entityClass, Long id) {
        String code = entityClass.code();
        Map<String, String> context = this.getContext();
        return new EntityDeleted(code, id, context);
    }

    private EntityCreated buildCreatedEvent(IEntityClass entityClass, Long id, Map<String, Object> data) {
        String code = entityClass.code();
        Map<String, String> context = this.getContext();
        return new EntityCreated(code, id, data, context);
    }

    private EntityUpdated buildUpdatedEvent(IEntityClass entityClass, Long id, Map<String, Object> data) {
        String code = entityClass.code();
        Map<String, String> context = this.getContext();
        return new EntityUpdated(code, id, data, context);
    }

    public void afterPropertiesSet() throws Exception {
        this.retryConfig = RetryConfig.custom().maxAttempts(this.maxAttempts).waitDuration(Duration.ofMillis(this.delay)).retryOnResult(response -> response == null || response.isLeft() && "CONFLICT".equalsIgnoreCase((String)response.getLeft())).build();
    }

    private static /* synthetic */ EntityUp lambda$updateByCondition$3(IEntityClass entityClass, List valueUps) {
        return EntityClassToGrpcConverter.toEntityUp(entityClass, null, valueUps);
    }
}

