/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.store.repository.impl;

import com.xforceplus.ultraman.oqsengine.sdk.event.MetadataModuleVersionMissingEvent;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.VersionService;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.impl.BoNode;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.impl.RingDC;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.impl.RingDCHolder;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.impl.VersionedModule;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.apache.metamodel.UpdateableDataContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;

public class DefaultVersionService
implements VersionService {
    private Logger logger = LoggerFactory.getLogger(VersionService.class);
    private Map<Long, LinkedList<VersionedModule>> currentVersionForModule = new HashMap<Long, LinkedList<VersionedModule>>();
    private Map<Long, String> currentModuleVersionMap = new HashMap<Long, String>();
    private Map<BoNode, LinkedList<Tuple2<Long, String>>> boModuleMapping = new HashMap<BoNode, LinkedList<Tuple2<Long, String>>>();
    private RingDCHolder dc;
    private int versionSize;
    private ApplicationEventPublisher publisher;
    private ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();

    public DefaultVersionService(int versionSize, ApplicationEventPublisher eventPublisher) {
        this.versionSize = versionSize;
        this.publisher = eventPublisher;
    }

    private <T> T read(Supplier<T> supplier) {
        this.rwLock.readLock().lock();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    private void write(Supplier<Void> supplier) {
        this.rwLock.writeLock().lock();
        try {
            supplier.get();
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public synchronized UpdateableDataContext getVersionedDCForBoById(long id, String version) {
        LinkedList<Tuple2<Long, String>> versionedList = this.findById(id);
        if (versionedList == null) {
            return null;
        }
        Optional<Tuple2> first = versionedList.stream().filter(x -> ((String)x._2()).equals(version)).findFirst();
        if (first.isPresent()) {
            return this.getVersionedDCForModule((Long)first.get()._1(), version);
        }
        if (versionedList.size() < this.versionSize && this.publisher != null) {
            Long relatedModuleId = (Long)((Tuple2)versionedList.get(0))._1();
            this.publisher.publishEvent((Object)new MetadataModuleVersionMissingEvent(relatedModuleId, version));
            return this.getVersionedDCForBoInner(id, version);
        }
        return null;
    }

    @Override
    public synchronized UpdateableDataContext getVersionedDCForBoByCode(String code, String version) {
        LinkedList<Tuple2<Long, String>> versionedList = this.findByCode(code);
        if (versionedList == null) {
            return null;
        }
        Optional<Tuple2> first = versionedList.stream().filter(x -> ((String)x._2()).equals(version)).findFirst();
        if (first.isPresent()) {
            return this.getVersionedDCForModule((Long)first.get()._1(), version);
        }
        if (versionedList.size() < this.versionSize && this.publisher != null) {
            Long relatedModuleId = (Long)((Tuple2)versionedList.get(0))._1();
            this.publisher.publishEvent((Object)new MetadataModuleVersionMissingEvent(relatedModuleId, version));
            return this.getVersionedDCForBoInner(code, version);
        }
        return null;
    }

    private UpdateableDataContext getVersionedDCForBoInner(long id, String version) {
        LinkedList<Tuple2<Long, String>> versionedList = this.findById(id);
        if (versionedList == null) {
            return null;
        }
        Optional<Tuple2> first = versionedList.stream().filter(x -> ((String)x._2()).equals(version)).findFirst();
        return first.map(longStringTuple2 -> this.getVersionedDCForModule((Long)longStringTuple2._1(), version)).orElse(null);
    }

    private UpdateableDataContext getVersionedDCForBoInner(String code, String version) {
        LinkedList<Tuple2<Long, String>> versionedList = this.findByCode(code);
        if (versionedList == null) {
            return null;
        }
        Optional<Tuple2> first = versionedList.stream().filter(x -> ((String)x._2()).equals(version)).findFirst();
        return first.map(longStringTuple2 -> this.getVersionedDCForModule((Long)longStringTuple2._1(), version)).orElse(null);
    }

    @Override
    public synchronized UpdateableDataContext getCurrentVersionDCForBoById(Long id) {
        LinkedList<Tuple2<Long, String>> versionedList = this.findById(id);
        if (versionedList == null) {
            return null;
        }
        Tuple2<Long, String> last = versionedList.getLast();
        if (last != null) {
            return this.getVersionedDCForModule((Long)last._1(), (String)last._2());
        }
        return null;
    }

    @Override
    public synchronized UpdateableDataContext getCurrentVersionDCForBoByCode(String code) {
        this.logger.debug("select code {}", (Object)code);
        LinkedList<Tuple2<Long, String>> versionedList = this.findByCode(code);
        if (versionedList == null) {
            this.logger.debug("current no such version {}", (Object)code);
            return null;
        }
        Tuple2<Long, String> last = versionedList.getLast();
        if (last != null) {
            this.logger.debug("got last version {} for {}", (Object)code, last._2());
            return this.getVersionedDCForModule((Long)last._1(), (String)last._2());
        }
        this.logger.debug("last version is empty {}", (Object)code);
        return null;
    }

    @Override
    public synchronized UpdateableDataContext getVersionedDCForModule(long id, String version) {
        LinkedList<VersionedModule> versionedModules = this.currentVersionForModule.get(id);
        return versionedModules.stream().filter(x -> x.getVersion().equals(version)).findAny().map(x -> x.getRingDC().getDc()).orElse(null);
    }

    @Override
    public synchronized void saveModule(long id, String version, List<BoNode> boIds) {
        String currentVersion = this.currentModuleVersionMap.get(id);
        if (currentVersion == null) {
            LinkedList<VersionedModule> list = new LinkedList<VersionedModule>();
            list.addLast(new VersionedModule(version, boIds, this.dc.getRoot(), System.currentTimeMillis()));
            this.currentVersionForModule.put(id, list);
            boIds.forEach(boNode -> {
                LinkedList<Tuple2> boList = new LinkedList<Tuple2>();
                boList.addLast(Tuple.of((Object)id, (Object)version));
                this.boModuleMapping.put((BoNode)boNode, (LinkedList<Tuple2<Long, String>>)boList);
            });
        } else if (!currentVersion.equals(version)) {
            this.logger.debug("CurrentVersion is {}, Version is {}\uff0c VersionSize is {}", new Object[]{currentVersion, version, this.versionSize});
            LinkedList<VersionedModule> list = this.currentVersionForModule.get(id);
            if (list.size() + 1 > this.versionSize) {
                this.logger.debug("version is overflow we need to roll it");
                list.removeFirst();
            }
            RingDC last = list.size() > 0 ? list.getLast().getRingDC() : this.dc.getRoot();
            list.addLast(new VersionedModule(version, boIds, last.next(), System.currentTimeMillis()));
            boIds.forEach(boNode -> {
                LinkedList<Object> boList = this.findById(boNode.getId());
                if (boList != null) {
                    if (boList.size() + 1 > this.versionSize) {
                        boList.removeFirst();
                    }
                } else {
                    boList = new LinkedList();
                    this.boModuleMapping.put((BoNode)boNode, (LinkedList<Tuple2<Long, String>>)boList);
                }
                boList.addLast(Tuple.of((Object)id, (Object)version));
            });
        }
        this.currentModuleVersionMap.put(id, version);
    }

    @Override
    public synchronized void initVersionedDC(int versionSize, Supplier<UpdateableDataContext> dcSupplier) {
        if (versionSize < 0) {
            versionSize = 1;
        }
        if (versionSize == 1) {
            UpdateableDataContext root = dcSupplier.get();
            this.dc = new RingDCHolder(new RingDC(root));
        } else {
            UpdateableDataContext root = dcSupplier.get();
            this.dc = new RingDCHolder(new RingDC(root));
            IntStream.range(0, versionSize - 1).mapToObj(x -> (UpdateableDataContext)dcSupplier.get()).forEach(x -> this.dc.addNode(new RingDC((UpdateableDataContext)x)));
        }
    }

    @Override
    public synchronized Map<Long, String> getCurrentVersion() {
        return Collections.unmodifiableMap(this.currentModuleVersionMap);
    }

    private LinkedList<Tuple2<Long, String>> findById(long id) {
        return this.boModuleMapping.entrySet().stream().filter(x -> ((BoNode)x.getKey()).getId().equals(id)).findFirst().map(Map.Entry::getValue).orElse(null);
    }

    private LinkedList<Tuple2<Long, String>> findByCode(String code) {
        return this.boModuleMapping.entrySet().stream().filter(x -> ((BoNode)x.getKey()).getCode().equals(code)).findFirst().map(Map.Entry::getValue).orElse(null);
    }

    @Override
    public synchronized Map<BoNode, LinkedList<Tuple2<Long, String>>> getBoModuleMapping() {
        return Collections.unmodifiableMap(this.boModuleMapping);
    }
}

