/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.transactional;

import com.xforceplus.ultraman.oqsengine.sdk.transactional.OqsTransaction;
import com.xforceplus.ultraman.oqsengine.sdk.transactional.OqsTransactionManager;
import com.xforceplus.ultraman.oqsengine.sdk.transactional.TransactionWrapperException;
import com.xforceplus.ultraman.oqsengine.sdk.transactional.annotation.OqsTransactional;
import com.xforceplus.ultraman.oqsengine.sdk.transactional.annotation.Propagation;
import com.xforceplus.xplat.galaxy.framework.context.ContextService;
import java.util.Stack;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

@Aspect
@Configuration
public class OqsTransactionalAOP {
    @Autowired
    private OqsTransactionManager oqsTransactionManager;
    private Logger logger = LoggerFactory.getLogger(OqsTransactionalAOP.class);

    @Around(value="@annotation(oqsTransactional)")
    public Object transactionExecution(ProceedingJoinPoint pjp, OqsTransactional oqsTransactional) throws Throwable {
        Propagation propagation = oqsTransactional.propagation();
        int timeout = oqsTransactional.timeout();
        Class<? extends Throwable>[] noRollBackForClass = oqsTransactional.noRollbackFor();
        Class<? extends Throwable>[] rollBackForClass = oqsTransactional.rollbackFor();
        try {
            Object output = this.oqsTransactionManager.transactionExecution(propagation, timeout, noRollBackForClass, rollBackForClass, () -> {
                try {
                    return pjp.proceed();
                }
                catch (Throwable throwable) {
                    throw new TransactionWrapperException(throwable);
                }
            });
            return output;
        }
        catch (Throwable throwable) {
            if (throwable instanceof TransactionWrapperException) {
                throw throwable.getCause();
            }
            throw throwable;
        }
    }

    public static enum TransactionKey implements ContextService.ContextKey<Stack<OqsTransaction>>
    {
        TRANSACTION_STACK;

    }
}

