/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.util.flow;

import akka.stream.ActorMaterializer;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.xforceplus.ultraman.oqsengine.sdk.util.flow.QueueFlow;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowRegistry {
    private ActorMaterializer mat;
    private Logger logger = LoggerFactory.getLogger(FlowRegistry.class);
    ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
    LoadingCache<String, QueueFlow> cache = Caffeine.newBuilder().maximumSize(1000L).expireAfterAccess(1L, TimeUnit.SECONDS).removalListener((RemovalListener)new RemovalListener<String, QueueFlow>(){

        public void onRemoval(@Nullable String s, @Nullable QueueFlow queueFlow, @NonNull RemovalCause removalCause) {
            FlowRegistry.this.logger.info("Flow for {} is over due to time expiry", (Object)s);
            if (queueFlow != null) {
                queueFlow.close();
            }
        }
    }).build(key -> {
        this.logger.info("Flow for {} is setup", key);
        return new QueueFlow((String)key, this.mat);
    });

    public FlowRegistry(ActorMaterializer mat) {
        this.mat = mat;
        this.scheduledExecutorService.scheduleAtFixedRate(() -> this.cache.cleanUp(), 2L, 10L, TimeUnit.SECONDS);
    }

    public <T> QueueFlow<T> flow(String name) {
        return (QueueFlow)this.cache.get((Object)name);
    }
}

