/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.config.init;

import com.alibaba.fastjson.JSON;
import com.xforceplus.ultraman.oqsengine.pojo.auth.Authorization;
import com.xforceplus.ultraman.oqsengine.pojo.dto.UltPage;
import com.xforceplus.ultraman.oqsengine.sdk.config.AuthSearcherConfig;
import com.xforceplus.ultraman.oqsengine.sdk.config.ExternalServiceConfig;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.PageBoMapLocalStore;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.Response;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Order(value=1)
@Component
public class UltPageInitService
implements CommandLineRunner {
    final Logger logger = LoggerFactory.getLogger(UltPageInitService.class);
    @Autowired
    private AuthSearcherConfig config;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private PageBoMapLocalStore pageBoMapLocalStore;

    public void run(String ... args) throws Exception {
        this.logger.info("begin init pages config");
        String accessUri = ExternalServiceConfig.PfcpAccessUri();
        String url = String.format("%s/pages/init", accessUri);
        Authorization auth = new Authorization();
        auth.setAppId(Long.valueOf(Long.parseLong(this.config.getAppId())));
        auth.setEnv(this.config.getEnv());
        Response result = new Response();
        try {
            HttpHeaders headers = new HttpHeaders();
            MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
            headers.setContentType(type);
            headers.add("Accept", MediaType.APPLICATION_JSON.toString());
            HttpEntity authorizeEntity = new HttpEntity((Object)auth, (MultiValueMap)headers);
            result = (Response)this.restTemplate.postForObject(url, (Object)authorizeEntity, Response.class, new Object[0]);
            if (result.getResult() != null) {
                List ultPages = (List)result.getResult();
                for (int i = 0; i < ultPages.size(); ++i) {
                    UltPage saveUltPage = (UltPage)JSON.parseObject((String)JSON.toJSONString(ultPages.get(i)), UltPage.class);
                    this.pageBoMapLocalStore.save(saveUltPage);
                }
                this.logger.info("init pages config success");
            }
        }
        catch (Exception e) {
            this.logger.info("init pages config faild");
            throw new Exception(String.format("init pages config faild,The url is '%s'.", url));
        }
    }
}

