/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.controller;

import com.xforceplus.ultraman.oqsengine.sdk.command.ConditionSearchCmd;
import com.xforceplus.ultraman.oqsengine.sdk.command.SingleCreateCmd;
import com.xforceplus.ultraman.oqsengine.sdk.command.SingleDeleteCmd;
import com.xforceplus.ultraman.oqsengine.sdk.command.SingleQueryCmd;
import com.xforceplus.ultraman.oqsengine.sdk.command.SingleUpdateCmd;
import com.xforceplus.ultraman.oqsengine.sdk.ui.DefaultUiService;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.Response;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.RowItem;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.SummaryItem;
import com.xforceplus.xplat.galaxy.framework.dispatcher.ServiceDispatcher;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping
public class EntityController {
    @Autowired
    private ServiceDispatcher dispatcher;
    private static String FAILED = "\u64cd\u4f5c\u5931\u8d25:";

    @GetMapping(value={"/bos/{boId}/entities/{id}"})
    @ResponseBody
    public ResponseEntity<Response<Map<String, Object>>> singleQuery(@PathVariable String boId, @PathVariable String id) {
        Either result = (Either)this.dispatcher.querySync((Object)new SingleQueryCmd(boId, id), DefaultUiService.class, "singleQuery");
        return (ResponseEntity)Optional.ofNullable(result).orElseGet(() -> Either.left((Object)"\u6ca1\u6709\u8fd4\u56de\u503c")).map(x -> {
            Response<Map> rep = new Response<Map>();
            rep.setCode("1");
            rep.setMessage("\u83b7\u53d6\u6210\u529f");
            rep.setResult((Map)x);
            return ResponseEntity.ok(rep);
        }).getOrElseGet(str -> {
            Response rep = new Response();
            rep.setCode("-1");
            rep.setMessage(FAILED.concat((String)str));
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(rep);
        });
    }

    @DeleteMapping(value={"/bos/{boId}/entities/{id}"})
    @ResponseBody
    public ResponseEntity<Response<String>> singleDelete(@PathVariable String boId, @PathVariable String id) {
        Either result = (Either)this.dispatcher.querySync((Object)new SingleDeleteCmd(boId, id), ResolvableType.forClassWithGenerics(Either.class, (Class[])new Class[]{String.class, Integer.class}));
        return (ResponseEntity)Optional.ofNullable(result).orElseGet(() -> Either.left((Object)"\u6ca1\u6709\u8fd4\u56de\u503c")).map(x -> {
            Response<String> rep = new Response<String>();
            rep.setCode("1");
            rep.setResult(String.valueOf(x));
            rep.setMessage("\u64cd\u4f5c\u6210\u529f");
            return ResponseEntity.ok(rep);
        }).getOrElseGet(str -> {
            Response<String> rep = new Response<String>();
            rep.setCode("-1");
            rep.setMessage(FAILED.concat((String)str));
            rep.setResult((String)str);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(rep);
        });
    }

    @PostMapping(value={"/bos/{boId}/entities"})
    @ResponseBody
    public ResponseEntity<Response<String>> singleCreate(@PathVariable String boId, @RequestBody Map<String, Object> body) {
        Either result = (Either)this.dispatcher.querySync((Object)new SingleCreateCmd(boId, body), DefaultUiService.class, "singleCreate");
        return (ResponseEntity)Optional.ofNullable(result).orElseGet(() -> Either.left((Object)"\u6ca1\u6709\u8fd4\u56de\u503c")).map(x -> {
            Response<String> rep = new Response<String>();
            rep.setCode("1");
            rep.setResult(String.valueOf(x));
            rep.setMessage("\u64cd\u4f5c\u6210\u529f");
            return ResponseEntity.ok(rep);
        }).getOrElseGet(str -> {
            Response<String> rep = new Response<String>();
            rep.setCode("-1");
            rep.setMessage(FAILED.concat((String)str));
            rep.setResult((String)str);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(rep);
        });
    }

    @PutMapping(value={"/bos/{boId}/entities/{id}"})
    @ResponseBody
    public ResponseEntity<Response<String>> singleModify(@PathVariable String boId, @PathVariable Long id, @RequestBody Map<String, Object> body) {
        Either result = (Either)this.dispatcher.querySync((Object)new SingleUpdateCmd(boId, id, body), ResolvableType.forClassWithGenerics(Either.class, (Class[])new Class[]{String.class, Integer.class}));
        return (ResponseEntity)Optional.ofNullable(result).orElseGet(() -> Either.left((Object)"\u6ca1\u6709\u8fd4\u56de\u503c")).map(x -> {
            Response<String> rep = new Response<String>();
            rep.setCode("1");
            rep.setResult(String.valueOf(x));
            rep.setMessage("\u64cd\u4f5c\u6210\u529f");
            return ResponseEntity.ok(rep);
        }).getOrElseGet(str -> {
            Response<String> rep = new Response<String>();
            rep.setCode("-1");
            rep.setMessage(FAILED.concat((String)str));
            rep.setResult((String)str);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(rep);
        });
    }

    @PostMapping(value={"/bos/{boId}/entities/query"})
    @ResponseBody
    public ResponseEntity<Response<RowItem<Map<String, Object>>>> conditionQuery(@PathVariable String boId, @RequestBody ConditionQueryRequest condition) {
        Either result = (Either)this.dispatcher.querySync((Object)new ConditionSearchCmd(boId, condition), DefaultUiService.class, "conditionSearch");
        return this.extractRepList(Optional.ofNullable(result).orElseGet(() -> Either.left((Object)"\u6ca1\u6709\u8fd4\u56de\u503c")));
    }

    private <T> ResponseEntity<Response<RowItem<T>>> extractRepList(Either<String, Tuple2<Integer, List<T>>> result) {
        Response rep = new Response();
        if (result.isRight()) {
            rep.setCode("1");
            Tuple2 tuple = (Tuple2)result.get();
            RowItem rowItem = new RowItem();
            rowItem.setSummary(new SummaryItem((Integer)tuple._1()));
            rowItem.setRows((List)tuple._2());
            rep.setResult(rowItem);
            rep.setMessage("\u64cd\u4f5c\u6210\u529f");
            return ResponseEntity.ok(rep);
        }
        rep.setCode("-1");
        rep.setMessage(FAILED.concat((String)result.getLeft()));
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(rep);
    }
}

