/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.controller;

import com.alibaba.fastjson.JSON;
import com.xforceplus.ultraman.oqsengine.pojo.auth.Authorization;
import com.xforceplus.ultraman.oqsengine.pojo.dto.UltPage;
import com.xforceplus.ultraman.oqsengine.sdk.config.AuthSearcherConfig;
import com.xforceplus.ultraman.oqsengine.sdk.config.ExternalServiceConfig;
import com.xforceplus.ultraman.oqsengine.sdk.service.EntityServiceEx;
import com.xforceplus.ultraman.oqsengine.sdk.store.RowUtils;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.PageBoMapLocalStore;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.Response;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ResponseList;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.UltPageBoItem;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.naming.directory.NoSuchAttributeException;
import javax.servlet.http.HttpServletRequest;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.query.builder.SatisfiedWhereBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.RestTemplate;

@RequestMapping
public class UltPageSettingController {
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private PageBoMapLocalStore pageBoMapLocalStore;
    @Autowired
    private AuthSearcherConfig config;
    @Autowired
    private EntityServiceEx entityServiceEx;

    @PostMapping(value={"/pages/{id}/deployments"})
    @ResponseBody
    public Response deploymentsPage(@PathVariable String id) throws NoSuchAttributeException {
        Response result = this.initSeetings(id);
        return result;
    }

    @GetMapping(value={"/pages/{id}/bo-settings"})
    @ResponseBody
    public Response pageBos(HttpServletRequest request, @PathVariable String id) throws NoSuchAttributeException {
        Object ds = null;
        String tenantId = request.getParameter("tenantId");
        Response<ResponseList> response = new Response<ResponseList>();
        if (!StringUtils.isEmpty((Object)id)) {
            ResponseList items = this.getPageBos(id, tenantId);
            if (items.size() > 0) {
                response.setMessage("\u67e5\u8be2\u6210\u529f");
                response.setCode("200");
                response.setResult(items);
                return response;
            }
            try {
                Response result = this.initSeetings(id);
                if (((List)result.getResult()).size() > 0) {
                    items = this.getPageBos(id, tenantId);
                }
                if (items.size() > 0) {
                    response.setMessage("\u67e5\u8be2\u6210\u529f");
                    response.setCode("200");
                    response.setResult(items);
                    return response;
                }
                response.setMessage("\u67e5\u8be2\u65e0\u7ed3\u679c");
                response.setCode("500");
                return response;
            }
            catch (Exception e) {
                response.setMessage("\u67e5\u8be2\u65e0\u7ed3\u679c");
                response.setCode("500");
                return response;
            }
        }
        response.setMessage("\u672a\u4f20id");
        response.setCode("1");
        return response;
    }

    @GetMapping(value={"/page-codes/{code}/bo-settings"})
    @ResponseBody
    public Response pageBosByCode(HttpServletRequest request, @PathVariable String code) throws NoSuchAttributeException {
        String tenantId = request.getParameter("tenantId");
        Response<ResponseList> response = new Response<ResponseList>();
        if (!StringUtils.isEmpty((Object)code)) {
            List<UltPageBoItem> items = this.entityServiceEx.findPageBos(code, tenantId);
            if (items.size() > 0) {
                response.setMessage("\u67e5\u8be2\u6210\u529f");
                response.setCode("200");
                response.setResult((ResponseList)items);
                return response;
            }
            response.setMessage("\u67e5\u8be2\u65e0\u7ed3\u679c");
            response.setCode("500");
            return response;
        }
        response.setMessage("\u672a\u4f20Code");
        response.setCode("500");
        return response;
    }

    @GetMapping(value={"/bo-settings/{id}"})
    @ResponseBody
    public Response pageBoSeetings(@PathVariable String id) {
        DataSet ds = null;
        Response response = new Response();
        if (!StringUtils.isEmpty((Object)id)) {
            ds = ((SatisfiedWhereBuilder)this.pageBoMapLocalStore.query().selectAll().where("settingId").eq(id)).execute();
            List rows = ds.toRows();
            ResponseList items = rows.stream().map(this::toUltPageBoSeeting).collect(Collectors.toCollection(ResponseList::new));
            response.setMessage("\u67e5\u8be2\u6210\u529f");
            response.setCode("1");
            if (items.size() == 1) {
                response.setResult(items.get(0));
            }
            return response;
        }
        response.setMessage("\u672a\u4f20id");
        response.setCode("1");
        return response;
    }

    private Response initSeetings(String id) throws NoSuchAttributeException {
        String accessUri = ExternalServiceConfig.PfcpAccessUri();
        String url = String.format("%s/pages/%s/deployments", accessUri, id);
        Authorization auth = new Authorization();
        auth.setAppId(Long.valueOf(Long.parseLong(this.config.getAppId())));
        auth.setEnv(this.config.getEnv());
        Response result = new Response();
        try {
            result = (Response)this.restTemplate.postForObject(url, (Object)auth, Response.class, new Object[0]);
            if (result.getResult() != null) {
                List ultPages = (List)result.getResult();
                for (int i = 0; i < ultPages.size(); ++i) {
                    UltPage saveUltPage = (UltPage)JSON.parseObject((String)JSON.toJSONString(ultPages.get(i)), UltPage.class);
                    this.pageBoMapLocalStore.save(saveUltPage);
                }
            }
            return result;
        }
        catch (Exception e) {
            result.setCode("400");
            result.setMessage("\u90e8\u7f72\u5931\u8d25");
            return result;
        }
    }

    private ResponseList getPageBos(String id, String tenantId) {
        DataSet ds = null;
        if (!StringUtils.isEmpty((Object)id)) {
            Response response = new Response();
            List trows = new ArrayList();
            if (!StringUtils.isEmpty((Object)tenantId)) {
                ds = ((SatisfiedWhereBuilder)((SatisfiedWhereBuilder)this.pageBoMapLocalStore.query().selectAll().where("refPageId").eq(id)).and("tenantId").eq(tenantId)).execute();
                trows = ds.toRows();
            }
            if (ds != null && trows != null && trows.size() > 0) {
                ResponseList items = trows.stream().map(this::toUltPageBos).collect(Collectors.toCollection(ResponseList::new));
                return items;
            }
            ds = ((SatisfiedWhereBuilder)this.pageBoMapLocalStore.query().selectAll().where("id").eq(id)).execute();
            List rows = ds.toRows();
            ResponseList items = rows.stream().map(this::toUltPageBos).collect(Collectors.toCollection(ResponseList::new));
            return items;
        }
        return null;
    }

    private ResponseList getSeetings(String id) {
        DataSet ds = null;
        if (!StringUtils.isEmpty((Object)id)) {
            Response response = new Response();
            ds = ((SatisfiedWhereBuilder)this.pageBoMapLocalStore.query().selectAll().where("settingId").eq(id)).execute();
            List rows = ds.toRows();
            ResponseList items = rows.stream().map(this::toUltPageBoSeeting).collect(Collectors.toCollection(ResponseList::new));
            return items;
        }
        return null;
    }

    private UltPageBoItem toUltPageBos(Row row) {
        UltPageBoItem ultPageBoItem = new UltPageBoItem();
        ultPageBoItem.setId(Long.parseLong(RowUtils.getRowValue(row, "settingId").map(Object::toString).orElse("")));
        ultPageBoItem.setPageId(Long.parseLong(RowUtils.getRowValue(row, "id").map(Object::toString).orElse("")));
        ultPageBoItem.setBoCode(RowUtils.getRowValue(row, "boCode").map(Object::toString).orElse(""));
        if (!"".equals(RowUtils.getRowValue(row, "tenantId").map(Object::toString).orElse(""))) {
            ultPageBoItem.setTenantId(Long.parseLong(RowUtils.getRowValue(row, "tenantId").map(Object::toString).orElse("")));
        }
        ultPageBoItem.setTenantName(RowUtils.getRowValue(row, "tenantName").map(Object::toString).orElse(""));
        ultPageBoItem.setBoName(RowUtils.getRowValue(row, "boName").map(Object::toString).orElse(""));
        ultPageBoItem.setRemark(RowUtils.getRowValue(row, "remark").map(Object::toString).orElse(""));
        ultPageBoItem.setEnvStatus(RowUtils.getRowValue(row, "envStatus").map(Object::toString).orElse(""));
        ultPageBoItem.setCode(RowUtils.getRowValue(row, "code").map(Object::toString).orElse(""));
        return ultPageBoItem;
    }

    private UltPageBoItem toUltPageBoSeeting(Row row) {
        UltPageBoItem ultPageBoItem = new UltPageBoItem();
        ultPageBoItem.setId(Long.parseLong(RowUtils.getRowValue(row, "settingId").map(Object::toString).orElse("")));
        ultPageBoItem.setPageId(Long.parseLong(RowUtils.getRowValue(row, "id").map(Object::toString).orElse("")));
        ultPageBoItem.setBoCode(RowUtils.getRowValue(row, "boCode").map(Object::toString).orElse(""));
        ultPageBoItem.setBoName(RowUtils.getRowValue(row, "boName").map(Object::toString).orElse(""));
        ultPageBoItem.setSetting(RowUtils.getRowValue(row, "setting").map(Object::toString).orElse(""));
        ultPageBoItem.setRemark(RowUtils.getRowValue(row, "remark").map(Object::toString).orElse(""));
        ultPageBoItem.setCode(RowUtils.getRowValue(row, "code").map(Object::toString).orElse(""));
        ultPageBoItem.setEnvStatus(RowUtils.getRowValue(row, "envStatus").map(Object::toString).orElse(""));
        return ultPageBoItem;
    }
}

