/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.handler;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.EntityClass;
import com.xforceplus.ultraman.oqsengine.sdk.command.ConditionSearchCmd;
import com.xforceplus.ultraman.oqsengine.sdk.command.SingleCreateCmd;
import com.xforceplus.ultraman.oqsengine.sdk.command.SingleDeleteCmd;
import com.xforceplus.ultraman.oqsengine.sdk.command.SingleQueryCmd;
import com.xforceplus.ultraman.oqsengine.sdk.command.SingleUpdateCmd;
import com.xforceplus.ultraman.oqsengine.sdk.service.EntityService;
import com.xforceplus.ultraman.oqsengine.sdk.ui.DefaultUiService;
import com.xforceplus.xplat.galaxy.framework.dispatcher.anno.QueryHandler;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultEntityServiceHandler
implements DefaultUiService {
    @Autowired
    private EntityService entityService;
    private static final String MISSING_ENTITES = "\u67e5\u8be2\u8bb0\u5f55\u4e0d\u5b58\u5728";

    @Override
    @QueryHandler(isDefault=true)
    public Either<String, Map<String, Object>> singleQuery(SingleQueryCmd cmd) {
        Optional<EntityClass> entityClassOp = this.entityService.load(cmd.getBoId());
        if (entityClassOp.isPresent()) {
            return this.entityService.findOne(entityClassOp.get(), Long.parseLong(cmd.getId()));
        }
        return Either.left((Object)MISSING_ENTITES);
    }

    @Override
    @QueryHandler(isDefault=true)
    public Either<String, Integer> singleDelete(SingleDeleteCmd cmd) {
        Optional<EntityClass> entityClassOp = this.entityService.load(cmd.getBoId());
        if (entityClassOp.isPresent()) {
            return this.entityService.deleteOne(entityClassOp.get(), Long.valueOf(cmd.getId()));
        }
        return Either.left((Object)MISSING_ENTITES);
    }

    @Override
    @QueryHandler(isDefault=true)
    public Either<String, Long> singleCreate(SingleCreateCmd cmd) {
        Optional<EntityClass> entityClassOp = this.entityService.load(cmd.getBoId());
        if (entityClassOp.isPresent()) {
            return this.entityService.create(entityClassOp.get(), cmd.getBody());
        }
        return Either.left((Object)MISSING_ENTITES);
    }

    @Override
    @QueryHandler(isDefault=true)
    public Either<String, Integer> singleUpdate(SingleUpdateCmd cmd) {
        Optional<EntityClass> entityClassOp = this.entityService.load(cmd.getBoId());
        if (entityClassOp.isPresent()) {
            return this.entityService.updateById(entityClassOp.get(), cmd.getId(), cmd.getBody());
        }
        return Either.left((Object)MISSING_ENTITES);
    }

    @Override
    @QueryHandler(isDefault=true)
    public Either<String, Tuple2<Integer, List<Map<String, Object>>>> conditionSearch(ConditionSearchCmd cmd) {
        Optional<EntityClass> entityClassOp = this.entityService.load(cmd.getBoId());
        if (entityClassOp.isPresent()) {
            return this.entityService.findByCondition(entityClassOp.get(), cmd.getConditionQueryRequest());
        }
        return Either.left((Object)MISSING_ENTITES);
    }
}

