/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.impl;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.EntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.Relation;
import com.xforceplus.ultraman.oqsengine.pojo.utils.IEntityClassHelper;
import com.xforceplus.ultraman.oqsengine.sdk.ConditionsUp;
import com.xforceplus.ultraman.oqsengine.sdk.FieldConditionUp;
import com.xforceplus.ultraman.oqsengine.sdk.service.HandleQueryValueService;
import com.xforceplus.ultraman.oqsengine.sdk.service.OperationType;
import com.xforceplus.ultraman.oqsengine.sdk.service.operation.QuerySideFieldOperationHandler;
import com.xforceplus.ultraman.oqsengine.sdk.service.operation.TriFunction;
import com.xforceplus.ultraman.oqsengine.sdk.util.EntityClassToGrpcConverter;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.Conditions;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.FieldCondition;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.SubFieldCondition;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultHandleQueryValueService
implements HandleQueryValueService {
    private Logger logger = LoggerFactory.getLogger(HandleQueryValueService.class);
    @Autowired
    List<QuerySideFieldOperationHandler> querySideFieldOperationHandler;

    @Override
    public ConditionsUp handleQueryValue(EntityClass entityClass, Conditions conditions, OperationType phase) {
        ConditionsUp.Builder conditionsUpBuilder = ConditionsUp.newBuilder();
        Stream<Optional> fieldInMainStream = Optional.ofNullable(conditions).map(Conditions::getFields).orElseGet(Collections::emptyList).stream().map(fieldCondition -> this.toFieldCondition(entityClass, (FieldCondition)fieldCondition));
        Stream fieldInRelationStream = Optional.ofNullable(conditions).map(x -> x.getEntities()).orElseGet(Collections::emptyList).stream().flatMap(entityCondition -> this.toFieldConditionFromRel(entityClass, (SubFieldCondition)entityCondition));
        conditionsUpBuilder.addAllFields((Iterable)Stream.concat(fieldInMainStream, fieldInRelationStream).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
        return conditionsUpBuilder.build();
    }

    private Stream<? extends Optional<FieldConditionUp>> toFieldConditionFromRel(EntityClass entityClass, SubFieldCondition entityCondition) {
        return entityClass.relations().stream().map(rel -> {
            Optional<FieldCondition> fieldConditionOp = entityCondition.getFields().stream().filter(enc -> {
                String code = entityCondition.getCode() + "." + enc.getCode();
                return rel.getEntityField().name().equalsIgnoreCase(code);
            }).findFirst();
            return fieldConditionOp.map(fieldCon -> Tuple.of((Object)fieldCon, (Object)rel));
        }).map(tuple -> tuple.map(this::toFieldCondition));
    }

    private Optional<FieldConditionUp> toFieldCondition(EntityClass entityClass, FieldCondition fieldCondition) {
        Optional fieldOp = IEntityClassHelper.findFieldByCode((IEntityClass)entityClass, (String)fieldCondition.getCode());
        return fieldOp.map(x -> FieldConditionUp.newBuilder().setCode(fieldCondition.getCode()).setOperation(Optional.ofNullable(fieldCondition.getOperation()).map(Enum::name).map(FieldConditionUp.Op::valueOf).orElse(FieldConditionUp.Op.eq)).addAllValues(this.doHandle((IEntityField)x, fieldCondition.getValue())).setField(EntityClassToGrpcConverter.toFieldUp((IEntityField)fieldOp.get())).build());
    }

    private FieldConditionUp toFieldCondition(Tuple2<FieldCondition, Relation> tuple) {
        FieldCondition fieldCondition = (FieldCondition)tuple._1();
        IEntityField entityField = ((Relation)tuple._2()).getEntityField();
        return FieldConditionUp.newBuilder().setCode(fieldCondition.getCode()).setOperation(FieldConditionUp.Op.valueOf((String)fieldCondition.getOperation().name())).addAllValues(this.doHandle(entityField, fieldCondition.getValue())).setField(EntityClassToGrpcConverter.toFieldUp(entityField)).build();
    }

    private List<String> doHandle(IEntityField field, List<String> origin) {
        return Optional.ofNullable(origin).orElseGet(Collections::emptyList).stream().filter(Objects::nonNull).map(input -> this.pipeline(input, field, OperationType.QUERY)).filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList());
    }

    private Object pipeline(Object value, IEntityField field, OperationType phase) {
        try {
            return this.querySideFieldOperationHandler.stream().sorted().map(x -> x).reduce(TriFunction::andThen).get().apply(field, value, phase);
        }
        catch (Exception ex) {
            this.logger.error("{}", (Throwable)ex);
            return null;
        }
    }
}

