/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.impl;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.EntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.Relation;
import com.xforceplus.ultraman.oqsengine.sdk.ValueUp;
import com.xforceplus.ultraman.oqsengine.sdk.service.HandleValueService;
import com.xforceplus.ultraman.oqsengine.sdk.service.OperationType;
import com.xforceplus.ultraman.oqsengine.sdk.service.operation.FieldOperationHandler;
import com.xforceplus.ultraman.oqsengine.sdk.service.operation.TriFunction;
import com.xforceplus.ultraman.oqsengine.sdk.service.operation.validator.FieldValidator;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.control.Validation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultHandleValueService
implements HandleValueService {
    @Autowired
    private List<FieldOperationHandler> fieldOperationHandlers;
    @Autowired
    private List<FieldValidator<Object>> fieldValidators;

    @Override
    public List<ValueUp> handlerValue(EntityClass entityClass, Map<String, Object> body, OperationType phase) {
        List<ValueUp> values = this.zipValue((IEntityClass)entityClass, body).map(tuple -> {
            Object obj;
            Object value;
            IEntityField field = (IEntityField)tuple._1();
            List<Validation<String, Object>> validations = this.validate(field, value = this.pipeline(obj = tuple._2(), field, phase), phase);
            if (!validations.isEmpty()) {
                throw new RuntimeException(validations.stream().map(Validation::getError).collect(Collectors.joining(",")));
            }
            if (value != null) {
                return ValueUp.newBuilder().setFieldId(field.id()).setFieldType(field.type().getType()).setValue(value.toString()).build();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return values;
    }

    private Stream<Tuple2<IEntityField, Object>> zipValue(IEntityClass entityClass, Map<String, Object> body) {
        Stream fields = entityClass.fields().stream();
        Stream<IEntityField> relationFields = entityClass.relations().stream().map(Relation::getEntityField).filter(Objects::nonNull);
        Stream parentFields = Optional.ofNullable(entityClass.extendEntityClass()).map(IEntityClass::fields).orElseGet(Collections::emptyList).stream();
        return Stream.concat(parentFields, Stream.concat(fields, relationFields)).distinct().map(x -> Tuple.of((Object)x, body.get(x.name())));
    }

    private Object pipeline(Object value, IEntityField field, OperationType phase) {
        return this.fieldOperationHandlers.stream().sorted().map(x -> x).reduce(TriFunction::andThen).get().apply(field, value, phase);
    }

    private List<Validation<String, Object>> validate(IEntityField field, Object obj, OperationType phase) {
        return this.fieldValidators.stream().map(x -> x.validate(field, obj, phase)).filter(Validation::isInvalid).collect(Collectors.toList());
    }
}

