/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.impl;

import akka.grpc.javadsl.SingleResponseRequestBuilder;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntity;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityFamily;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.Entity;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.EntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.EntityFamily;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.EntityValue;
import com.xforceplus.ultraman.oqsengine.sdk.EntityServiceClient;
import com.xforceplus.ultraman.oqsengine.sdk.EntityUp;
import com.xforceplus.ultraman.oqsengine.sdk.OperationResult;
import com.xforceplus.ultraman.oqsengine.sdk.ValueUp;
import com.xforceplus.ultraman.oqsengine.sdk.event.EntityCreated;
import com.xforceplus.ultraman.oqsengine.sdk.service.EntityServiceEx;
import com.xforceplus.ultraman.oqsengine.sdk.service.HandleValueService;
import com.xforceplus.ultraman.oqsengine.sdk.service.OperationType;
import com.xforceplus.ultraman.oqsengine.sdk.store.RowUtils;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.DictMapLocalStore;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.PageBoMapLocalStore;
import com.xforceplus.ultraman.oqsengine.sdk.util.EntityClassToGrpcConverter;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.DictItem;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ResponseList;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.UltPageBoItem;
import com.xforceplus.xplat.galaxy.framework.context.ContextKeys;
import com.xforceplus.xplat.galaxy.framework.context.ContextService;
import io.vavr.control.Either;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.query.builder.SatisfiedWhereBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.util.StringUtils;

public class EntityServiceExImpl
implements EntityServiceEx {
    private final ContextService contextService;
    private final EntityServiceClient entityServiceClient;
    @Autowired
    private PageBoMapLocalStore pageBoMapLocalStore;
    @Autowired
    private DictMapLocalStore dictMapLocalStore;
    @Autowired
    private HandleValueService handleValueService;
    @Autowired
    private ApplicationEventPublisher publisher;

    public EntityServiceExImpl(ContextService contextService, EntityServiceClient entityServiceClient) {
        this.contextService = contextService;
        this.entityServiceClient = entityServiceClient;
    }

    @Override
    public Either<String, IEntity> create(EntityClass entityClass, Map<String, Object> body) {
        List<ValueUp> valueUps;
        OperationResult createResult;
        String transId = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY);
        SingleResponseRequestBuilder buildBuilder = this.entityServiceClient.build();
        if (transId != null) {
            buildBuilder.addHeader("transaction-id", transId);
        }
        if ((createResult = (OperationResult)buildBuilder.invoke((Object)EntityClassToGrpcConverter.toEntityUp(entityClass, null, valueUps = this.handleValueService.handlerValue(entityClass, body, OperationType.CREATE))).toCompletableFuture().join()).getCode() == OperationResult.Code.OK) {
            if (createResult.getIdsList().size() < 1) {
                return Either.left((Object)"\u672a\u83b7\u5f97\u7ed3\u679c");
            }
            Entity entity = null;
            if (createResult.getIdsCount() == 1) {
                Long id = (Long)createResult.getIdsList().get(0);
                entity = new Entity(id.longValue(), (IEntityClass)entityClass, (IEntityValue)new EntityValue(0L));
                this.publisher.publishEvent((Object)this.buildCreatedEvent(entityClass, id, null, body));
            } else if (createResult.getIdsCount() > 1) {
                Long id = (Long)createResult.getIdsList().get(0);
                Long parentId = (Long)createResult.getIdsList().get(1);
                entity = new Entity(((Long)createResult.getIdsList().get(0)).longValue(), (IEntityClass)entityClass, (IEntityValue)new EntityValue(0L), (IEntityFamily)new EntityFamily(((Long)createResult.getIdsList().get(1)).longValue(), 0L), 0);
                this.publisher.publishEvent((Object)this.buildCreatedEvent(entityClass, parentId, id, body));
            } else {
                return Either.left((Object)createResult.getMessage());
            }
            return Either.right((Object)entity);
        }
        return Either.left((Object)createResult.getMessage());
    }

    private Map<String, String> getContext() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(ContextKeys.StringKeys.TENANTID_KEY.name(), (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTID_KEY));
        map.put(ContextKeys.StringKeys.TENANTCODE_KEY.name(), (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTCODE_KEY));
        map.put(ContextKeys.StringKeys.USERNAME.name(), (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.USERNAME));
        map.put(ContextKeys.StringKeys.USER_DISPLAYNAME.name(), (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.USER_DISPLAYNAME));
        return map;
    }

    private EntityCreated buildCreatedEvent(EntityClass entityClass, Long id, Long childId, Map<String, Object> data) {
        String code = entityClass.code();
        String parentCode = null;
        Map<String, String> context = this.getContext();
        if (entityClass.extendEntityClass() != null) {
            parentCode = entityClass.extendEntityClass().code();
        }
        return new EntityCreated(parentCode, code, id, childId, data, context);
    }

    @Override
    public Either<String, Map<String, Object>> findOneByParentId(EntityClass entityClass, EntityClass subEntityClass, long id) {
        if (subEntityClass != null && subEntityClass.extendEntityClass() != null && entityClass != null && entityClass.id() == subEntityClass.extendEntityClass().id()) {
            EntityUp entityUp;
            OperationResult queryResult;
            String transId = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY);
            SingleResponseRequestBuilder queryResultBuilder = this.entityServiceClient.selectOne();
            if (transId != null) {
                queryResultBuilder.addHeader("transaction-id", transId);
            }
            if ((queryResult = (OperationResult)queryResultBuilder.invoke((Object)(entityUp = EntityClassToGrpcConverter.toEntityUpBuilder((IEntityClass)entityClass, id).setSubEntityClass(EntityClassToGrpcConverter.toRawEntityUp((IEntityClass)subEntityClass)).build())).toCompletableFuture().join()).getCode() == OperationResult.Code.OK) {
                if (queryResult.getTotalRow() > 0) {
                    return Either.right(EntityClassToGrpcConverter.toResultMap(entityClass, subEntityClass, (EntityUp)queryResult.getQueryResultList().get(0)));
                }
                return Either.left((Object)"\u672a\u67e5\u8be2\u5230\u8bb0\u5f55");
            }
            return Either.left((Object)queryResult.getMessage());
        }
        return Either.left((Object)"error parameters");
    }

    @Override
    public List<UltPageBoItem> findPageBos(String pageCode, String tenantId) {
        DataSet ds = null;
        if (!StringUtils.isEmpty((Object)pageCode)) {
            List trows = new ArrayList();
            if (!StringUtils.isEmpty((Object)tenantId)) {
                ds = ((SatisfiedWhereBuilder)((SatisfiedWhereBuilder)((SatisfiedWhereBuilder)this.pageBoMapLocalStore.query().selectAll().where("code").eq(pageCode)).and("tenantId").eq(tenantId)).and("envStatus").eq("UP")).execute();
                trows = ds.toRows();
            }
            if (ds != null && trows != null && trows.size() > 0) {
                ResponseList items = trows.stream().map(this::toUltPageBos).collect(Collectors.toCollection(ResponseList::new));
                return items;
            }
            ds = ((SatisfiedWhereBuilder)((SatisfiedWhereBuilder)((SatisfiedWhereBuilder)this.pageBoMapLocalStore.query().selectAll().where("code").eq(pageCode)).and("envStatus").eq("UP")).and("tenantId").isNull()).execute();
            List rows = ds.toRows();
            ResponseList items = rows.stream().map(this::toUltPageBos).collect(Collectors.toCollection(ResponseList::new));
            return items;
        }
        return null;
    }

    @Override
    public List<DictItem> findDictItems(String enumId, String enumCode) {
        DataSet ds = null;
        List rows = new ArrayList();
        if (StringUtils.isEmpty((Object)enumCode)) {
            ds = ((SatisfiedWhereBuilder)this.dictMapLocalStore.query().selectAll().where("publishDictId").eq(enumId)).execute();
            rows = ds.toRows();
            if (rows == null || rows.size() <= 0) {
                ds = ((SatisfiedWhereBuilder)this.dictMapLocalStore.query().selectAll().where("dictId").eq(enumId)).execute();
                rows = ds.toRows();
            }
        } else {
            ds = ((SatisfiedWhereBuilder)((SatisfiedWhereBuilder)this.dictMapLocalStore.query().selectAll().where("publishDictId").eq(enumId)).and("code").eq(enumCode)).execute();
            rows = ds.toRows();
            if (rows == null || rows.size() <= 0) {
                ds = ((SatisfiedWhereBuilder)((SatisfiedWhereBuilder)this.dictMapLocalStore.query().selectAll().where("dictId").eq(enumId)).and("code").eq(enumCode)).execute();
                rows = ds.toRows();
            }
        }
        List items = rows.stream().map(this::toDictItem).collect(Collectors.toCollection(ResponseList::new));
        return this.getMaxVersionList(items);
    }

    @Override
    public List<DictItem> findDictItemsByCode(String code, String enumCode) {
        DataSet ds = null;
        List rows = new ArrayList();
        if (StringUtils.isEmpty((Object)enumCode)) {
            ds = ((SatisfiedWhereBuilder)this.dictMapLocalStore.query().selectAll().where("dictCode").eq(code)).execute();
            rows = ds.toRows();
        } else {
            ds = ((SatisfiedWhereBuilder)((SatisfiedWhereBuilder)this.dictMapLocalStore.query().selectAll().where("dictCode").eq(code)).and("code").eq(enumCode)).execute();
            rows = ds.toRows();
        }
        List items = rows.stream().map(this::toDictItem).collect(Collectors.toCollection(ResponseList::new));
        return this.getMaxVersionList(items);
    }

    private UltPageBoItem toUltPageBos(Row row) {
        UltPageBoItem ultPageBoItem = new UltPageBoItem();
        ultPageBoItem.setId(Long.parseLong(RowUtils.getRowValue(row, "settingId").map(Object::toString).orElse("")));
        ultPageBoItem.setPageId(Long.parseLong(RowUtils.getRowValue(row, "id").map(Object::toString).orElse("")));
        ultPageBoItem.setBoCode(RowUtils.getRowValue(row, "boCode").map(Object::toString).orElse(""));
        if (!"".equals(RowUtils.getRowValue(row, "tenantId").map(Object::toString).orElse(""))) {
            ultPageBoItem.setTenantId(Long.parseLong(RowUtils.getRowValue(row, "tenantId").map(Object::toString).orElse("")));
        }
        ultPageBoItem.setTenantName(RowUtils.getRowValue(row, "tenantName").map(Object::toString).orElse(""));
        ultPageBoItem.setBoName(RowUtils.getRowValue(row, "boName").map(Object::toString).orElse(""));
        ultPageBoItem.setRemark(RowUtils.getRowValue(row, "remark").map(Object::toString).orElse(""));
        ultPageBoItem.setCode(RowUtils.getRowValue(row, "code").map(Object::toString).orElse(""));
        ultPageBoItem.setEnvStatus(RowUtils.getRowValue(row, "envStatus").map(Object::toString).orElse(""));
        return ultPageBoItem;
    }

    private DictItem toDictItem(Row row) {
        DictItem dictItem = new DictItem();
        dictItem.setText(RowUtils.getRowValue(row, "name").map(Object::toString).orElse(""));
        dictItem.setValue(RowUtils.getRowValue(row, "code").map(Object::toString).orElse(""));
        dictItem.setVersion(RowUtils.getRowValue(row, "version").map(Object::toString).orElse(""));
        return dictItem;
    }

    private List<DictItem> getMaxVersionList(List<DictItem> dictItems) {
        ResponseList<DictItem> dictItemList = new ResponseList<DictItem>();
        if (dictItems.size() > 0) {
            String maxVersion = dictItems.get(0).getVersion();
            for (int i = 0; i < dictItems.size(); ++i) {
                if (this.compare(maxVersion, dictItems.get(i).getVersion()) < 0) {
                    dictItemList.clear();
                    dictItemList.add(dictItems.get(i));
                    maxVersion = dictItems.get(i).getVersion();
                    continue;
                }
                dictItemList.add(dictItems.get(i));
            }
        }
        return dictItemList;
    }

    public int compare(String v1, String v2) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)v1) && org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)v2)) {
            return 0;
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)v1)) {
            return -1;
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)v2)) {
            return 1;
        }
        int[] varr1 = this.getVersionArray(v1);
        int[] varr2 = this.getVersionArray(v2);
        int lim = Math.min(varr1.length, varr2.length);
        for (int k = 0; k < lim; ++k) {
            if (varr1[k] == varr2[k]) {
                continue;
            }
            return varr1[k] > varr2[k] ? 1 : -1;
        }
        if (varr1.length == varr2.length) {
            return 0;
        }
        return varr1.length > varr2.length ? 1 : -1;
    }

    public int[] getVersionArray(String v) {
        String[] sarray = org.apache.commons.lang3.StringUtils.split((String)v, (String)".");
        int[] varray = new int[sarray.length];
        for (int k = 0; k < sarray.length; ++k) {
            varray[k] = Integer.parseInt(sarray[k]);
        }
        return varray;
    }
}

