/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.operation.validator;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.sdk.service.operation.validator.ConsistFieldValidator;
import io.vavr.control.Validation;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.springframework.util.StringUtils;

public class RegxValidator
implements ConsistFieldValidator<Object> {
    @Override
    public Validation<String, Object> validate(IEntityField field, Object obj) {
        if (obj != null && !StringUtils.isEmpty((Object)field.config().getValidateRegexString())) {
            Pattern pattern = Pattern.compile(field.config().getValidateRegexString());
            if (this.isSplittable(field)) {
                String[] term = obj.toString().split(field.config().getValidateRegexString());
                return Stream.of(term).allMatch(x -> this.checkRegex(pattern, (String)x)) ? Validation.valid((Object)obj) : Validation.invalid((Object)String.format("%s is not satisfied with regex %s", obj, field.config().getValidateRegexString()));
            }
            return this.checkRegex(pattern, obj.toString()) ? Validation.valid((Object)obj) : Validation.invalid((Object)String.format("%s is not satisfied with regex %s", obj, field.config().getValidateRegexString()));
        }
        return Validation.valid((Object)obj);
    }

    private boolean checkRegex(Pattern pattern, String obj) {
        return pattern.matcher(obj).matches();
    }
}

