/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.store.repository.impl;

import com.xforceplus.ultraman.metadata.grpc.Api;
import com.xforceplus.ultraman.metadata.grpc.BoUp;
import com.xforceplus.ultraman.metadata.grpc.Field;
import com.xforceplus.ultraman.metadata.grpc.ModuleUpResult;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldLikeRelationType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.EntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.Relation;
import com.xforceplus.ultraman.oqsengine.sdk.store.RowUtils;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.MetadataRepository;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.SimpleBoItem;
import com.xforceplus.ultraman.oqsengine.sdk.util.FieldHelper;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ApiItem;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.BoItem;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.FieldItem;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.SoloItem;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.metamodel.UpdateScript;
import org.apache.metamodel.UpdateSummary;
import org.apache.metamodel.UpdateableDataContext;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.delete.RowDeletionBuilder;
import org.apache.metamodel.insert.InsertInto;
import org.apache.metamodel.pojo.MapTableDataProvider;
import org.apache.metamodel.pojo.PojoDataContext;
import org.apache.metamodel.pojo.TableDataProvider;
import org.apache.metamodel.query.builder.SatisfiedWhereBuilder;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.SimpleTableDef;

public class MetadataRepositoryInMemoryImpl
implements MetadataRepository {
    private List<Map<String, ?>> boStore = new ArrayList();
    private List<Map<String, ?>> apiStore = new ArrayList();
    private List<Map<String, ?>> fieldStore = new ArrayList();
    private List<Map<String, ?>> RelationStore = new ArrayList();
    private UpdateableDataContext dc;

    public MetadataRepositoryInMemoryImpl() {
        SimpleTableDef boTableDef = new SimpleTableDef("bos", new String[]{"id", "code", "parentId"});
        MapTableDataProvider boTableDataProvider = new MapTableDataProvider(boTableDef, this.boStore);
        SimpleTableDef ApiTableDef = new SimpleTableDef("apis", new String[]{"boId", "url", "method", "code"});
        MapTableDataProvider apiTableDataProvider = new MapTableDataProvider(ApiTableDef, this.apiStore);
        SimpleTableDef fieldTableDef = new SimpleTableDef("fields", new String[]{"boId", "id", "code", "displayType", "editable", "enumCode", "maxLength", "name", "required", "fieldType", "searchable", "dictId", "defaultValue", "precision", "identifier", "validateRule"});
        MapTableDataProvider fieldTableDataProvider = new MapTableDataProvider(fieldTableDef, this.fieldStore);
        SimpleTableDef relationTableDef = new SimpleTableDef("rels", new String[]{"id", "boId", "relType", "identity", "joinBoId"});
        MapTableDataProvider relationTableDataProvider = new MapTableDataProvider(relationTableDef, this.RelationStore);
        this.dc = new PojoDataContext("metadata", new TableDataProvider[]{boTableDataProvider, apiTableDataProvider, fieldTableDataProvider, relationTableDataProvider});
    }

    private Map<String, ApiItem> toApiItemMap(DataSet apis) {
        HashMap<String, ApiItem> map = new HashMap<String, ApiItem>();
        while (apis.next()) {
            Row row = apis.getRow();
            String code = RowUtils.getRowValue(row, "code").map(String::valueOf).orElse("");
            String url = RowUtils.getRowValue(row, "url").map(String::valueOf).orElse("");
            String method = RowUtils.getRowValue(row, "method").map(String::valueOf).orElse("");
            ApiItem apiItem = new ApiItem(url, method);
            map.put(code, apiItem);
        }
        return map;
    }

    private List<FieldItem> toFieldItemList(DataSet fields) {
        ArrayList<FieldItem> items = new ArrayList<FieldItem>();
        while (fields.next()) {
            Row row = fields.getRow();
            FieldItem fieldItem = new FieldItem();
            fieldItem.setCode(RowUtils.getRowValue(row, "code").map(String::valueOf).orElse(""));
            fieldItem.setDisplayType(RowUtils.getRowValue(row, "displayType").map(String::valueOf).orElse(""));
            fieldItem.setEditable(RowUtils.getRowValue(row, "editable").map(String::valueOf).orElse(""));
            fieldItem.setEnumCode(RowUtils.getRowValue(row, "enumCode").map(String::valueOf).orElse(""));
            fieldItem.setMaxLength(RowUtils.getRowValue(row, "maxLength").map(String::valueOf).orElse(""));
            fieldItem.setName(RowUtils.getRowValue(row, "name").map(String::valueOf).orElse(""));
            fieldItem.setRequired(RowUtils.getRowValue(row, "required").map(String::valueOf).orElse(""));
            fieldItem.setType(RowUtils.getRowValue(row, "fieldType").map(String::valueOf).orElse(""));
            fieldItem.setSearchable(RowUtils.getRowValue(row, "searchable").map(String::valueOf).orElse(""));
            fieldItem.setDictId(RowUtils.getRowValue(row, "dictId").map(String::valueOf).orElse(""));
            fieldItem.setDefaultValue(RowUtils.getRowValue(row, "defaultValue").map(String::valueOf).orElse(""));
            fieldItem.setPrecision(RowUtils.getRowValue(row, "precision").map(String::valueOf).orElse(""));
            fieldItem.setRelationshipEntity(null);
            items.add(fieldItem);
        }
        return items;
    }

    @Override
    public synchronized BoItem getBoDetailById(String id) {
        DataSet boDetails = ((SatisfiedWhereBuilder)this.dc.query().from("bos").selectAll().where("id").eq(id)).execute();
        if (boDetails.next()) {
            Row ds = boDetails.getRow();
            DataSet apis = ((SatisfiedWhereBuilder)this.dc.query().from("apis").selectAll().where("boId").eq(id)).execute();
            Map<String, ApiItem> apiItemMap = this.toApiItemMap(apis);
            DataSet fields = ((SatisfiedWhereBuilder)this.dc.query().from("fields").selectAll().where("boId").eq(id)).execute();
            List<FieldItem> fieldItemList = this.toFieldItemList(fields);
            DataSet rels = ((SatisfiedWhereBuilder)this.dc.query().from("rels").selectAll().where("boId").eq(id)).execute();
            List rows = rels.toRows();
            List<String> relIds = rows.stream().map(x -> RowUtils.getRowValue(x, "joinBoId").map(String::valueOf).orElse("")).collect(Collectors.toList());
            List<FieldItem> relField = this.loadRelationField(rows, row -> {
                String joinBoId = RowUtils.getRowValue(row, "joinBoId").map(String::valueOf).orElse("");
                DataSet boDs = ((SatisfiedWhereBuilder)this.dc.query().from("bos").selectAll().where("id").eq(joinBoId)).execute();
                if (boDs.next()) {
                    Row bo = boDs.getRow();
                    String boCode = RowUtils.getRowValue(bo, "code").map(String::valueOf).orElse("");
                    SoloItem soloItem = new SoloItem();
                    soloItem.setId(Long.valueOf(joinBoId));
                    return new FieldItem(boCode.concat(".id"), boCode.concat(".id"), FieldType.LONG.getType(), "", "false", "true", "false", null, null, "0", "", "", soloItem);
                }
                return null;
            });
            LinkedList<FieldItem> fieldTotalItems = new LinkedList<FieldItem>();
            fieldTotalItems.addAll(fieldItemList);
            fieldTotalItems.addAll(relField);
            BoItem boItem = new BoItem();
            boItem.setApi(apiItemMap);
            boItem.setFields(fieldTotalItems);
            boItem.setParentEntityId(RowUtils.getRowValue(ds, "parentId").map(String::valueOf).orElse(""));
            boItem.setSubEntities(relIds);
            return boItem;
        }
        return null;
    }

    @Override
    public void save(ModuleUpResult moduleUpResult, String tenantId, String appId) {
        moduleUpResult.getBoUpsList().forEach(boUp -> {
            this.clearAllBoIdRelated(boUp.getId());
            this.insertBo((BoUp)boUp);
        });
    }

    private synchronized Optional<IEntityClass> loadParentEntityClass(String boId) {
        DataSet boDs = ((SatisfiedWhereBuilder)this.dc.query().from("bos").selectAll().where("id").eq(boId)).execute();
        if (boDs.next()) {
            Row row = boDs.getRow();
            String code = RowUtils.getRowValue(row, "code").map(String::valueOf).orElse("");
            return Optional.of(new EntityClass(Long.valueOf(boId), code, Collections.emptyList(), Collections.emptyList(), null, this.loadFields(boId)));
        }
        return Optional.empty();
    }

    private synchronized Optional<Tuple2<Relation, IEntityClass>> loadRelationEntityClass(String boId, Row relRow, String mainBoCode) {
        String relationType = RowUtils.getRowValue(relRow, "relType").map(String::valueOf).orElse("");
        String name = RowUtils.getRowValue(relRow, "name").map(String::valueOf).orElse("");
        Long joinBoId = RowUtils.getRowValue(relRow, "joinBoId").map(String::valueOf).map(Long::valueOf).orElse(0L);
        Long relId = RowUtils.getRowValue(relRow, "id").map(String::valueOf).map(Long::valueOf).orElse(0L);
        return this.findOneById("bos", boId).map(row -> {
            Optional parentEntityClass = RowUtils.getRowValue(row, "parentId").map(String::valueOf).flatMap(this::loadParentEntityClass);
            String subCode = RowUtils.getRowValue(row, "code").map(String::valueOf).orElse("");
            LinkedList<IEntityField> listFields = new LinkedList<IEntityField>();
            Relation relation = new Relation(relId, name, joinBoId.longValue(), subCode, mainBoCode, relationType);
            FieldLikeRelationType.from((String)relationType).ifPresent(x -> {
                IEntityField relField = x.getField(relation);
                relation.setEntityField(relField);
                if (!x.isOwnerSide()) {
                    listFields.add(relField);
                }
            });
            listFields.addAll(this.loadFields(boId));
            EntityClass entityClass = new EntityClass(Long.valueOf(boId), subCode, Collections.emptyList(), Collections.emptyList(), (IEntityClass)parentEntityClass.orElse(null), listFields);
            return Tuple.of((Object)relation, (Object)entityClass);
        });
    }

    @Override
    public synchronized Optional<EntityClass> loadByCode(String tenantId, String appCode, String boCode) {
        DataSet boDs = ((SatisfiedWhereBuilder)this.dc.query().from("bos").selectAll().where("code").eq(boCode)).execute();
        if (boDs.next()) {
            return this.toEntityClass(boDs.getRow());
        }
        return Optional.empty();
    }

    @Override
    public synchronized List<EntityClass> findSubEntitiesById(String tenantId, String appId, String parentId) {
        DataSet boDs = ((SatisfiedWhereBuilder)this.dc.query().from("bos").selectAll().where("parentId").eq(parentId)).execute();
        List rows = boDs.toRows();
        return rows.stream().map(this::toEntityClass).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    @Override
    public synchronized List<EntityClass> findSubEntitiesByCode(String tenantId, String appId, String parentCode) {
        DataSet boDs = ((SatisfiedWhereBuilder)this.dc.query().from("bos").selectAll().where("code").eq(parentCode)).execute();
        if (boDs.next()) {
            String id = RowUtils.getRowValue(boDs.getRow(), "id").map(String::valueOf).orElse("");
            return this.findSubEntitiesById(tenantId, appId, id);
        }
        return Collections.emptyList();
    }

    @Override
    public synchronized Optional<EntityClass> load(String tenantId, String appCode, String boId) {
        DataSet boDs = ((SatisfiedWhereBuilder)this.dc.query().from("bos").selectAll().where("id").eq(boId)).execute();
        if (boDs.next()) {
            return this.toEntityClass(boDs.getRow());
        }
        return Optional.empty();
    }

    private Optional<EntityClass> toEntityClass(Row row) {
        String code = RowUtils.getRowValue(row, "code").map(String::valueOf).orElse("");
        String boId = RowUtils.getRowValue(row, "id").map(String::valueOf).orElse("0");
        List<IEntityField> fields = this.loadFields(boId);
        String parentId = RowUtils.getRowValue(row, "parentId").map(String::valueOf).orElse("");
        Optional<IEntityClass> parentEntityClassOp = this.loadParentEntityClass(parentId);
        DataSet relDs = ((SatisfiedWhereBuilder)this.dc.query().from("rels").selectAll().where("boId").eq(boId)).execute();
        List relsRows = relDs.toRows();
        List<Tuple2> relatedEntityClassList = relsRows.stream().map(relRow -> {
            Optional<String> relatedBoIdOp = RowUtils.getRowValue(relRow, "joinBoId").map(String::valueOf);
            return relatedBoIdOp.flatMap(x -> this.loadRelationEntityClass((String)x, (Row)relRow, code));
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        LinkedList entityClassList = new LinkedList();
        LinkedList relationList = new LinkedList();
        LinkedList<IEntityField> allFields = new LinkedList<IEntityField>();
        allFields.addAll(fields);
        relatedEntityClassList.forEach(tuple -> {
            entityClassList.add(tuple._2());
            relationList.add(tuple._1());
        });
        relationList.stream().filter(x -> FieldLikeRelationType.from((String)x.getRelationType()).map(FieldLikeRelationType::isOwnerSide).orElse(false)).forEach(x -> allFields.add(x.getEntityField()));
        EntityClass entityClass = new EntityClass(Long.valueOf(boId), code, relationList, entityClassList, (IEntityClass)parentEntityClassOp.orElse(null), allFields);
        return Optional.of(entityClass);
    }

    private List<IEntityField> loadRelationField(String id) {
        DataSet relDs = ((SatisfiedWhereBuilder)this.dc.query().from("rels").selectAll().where("boId").eq(id)).execute();
        return this.loadRelationField(relDs.toRows());
    }

    private <U> List<U> loadRelationField(List<Row> relations, Function<Row, U> mapper) {
        return relations.stream().filter(row -> RowUtils.getRowValue(row, "relType").map(String::valueOf).filter(type -> type.equalsIgnoreCase("onetoone") || type.equalsIgnoreCase("manytoone")).isPresent()).map(mapper).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Table getTable(String tableName) {
        return this.dc.getTableByQualifiedLabel("metadata." + tableName);
    }

    private synchronized Optional<Row> findOneById(String tableName, String id) {
        DataSet ds = ((SatisfiedWhereBuilder)this.dc.query().from(tableName).selectAll().where("id").eq(id)).execute();
        if (ds.next()) {
            return Optional.ofNullable(ds.getRow());
        }
        return Optional.empty();
    }

    @Override
    public synchronized void clearAllBoIdRelated(String boId) {
        UpdateSummary updateSummary = this.dc.executeUpdate(callback -> {
            ((RowDeletionBuilder)callback.deleteFrom(this.getTable("bos")).where("id").eq(boId)).execute();
            ((RowDeletionBuilder)callback.deleteFrom(this.getTable("apis")).where("boId").eq(boId)).execute();
            ((RowDeletionBuilder)callback.deleteFrom(this.getTable("fields")).where("boId").eq(boId)).execute();
            ((RowDeletionBuilder)callback.deleteFrom(this.getTable("rels")).where("boId").eq(boId)).execute();
        });
    }

    @Override
    public synchronized SimpleBoItem findOneById(String boId) {
        DataSet boDs = ((SatisfiedWhereBuilder)this.dc.query().from("bos").selectAll().where("id").eq(boId)).execute();
        if (boDs.next()) {
            SimpleBoItem simpleBoItem = new SimpleBoItem();
            Row row = boDs.getRow();
            simpleBoItem.setCode(RowUtils.getRowValue(row, "code").map(String::valueOf).orElse(""));
            simpleBoItem.setParentId(RowUtils.getRowValue(row, "parentId").map(String::valueOf).orElse(""));
            simpleBoItem.setId(boId);
            return simpleBoItem;
        }
        return null;
    }

    private synchronized void insertBoTable(String id, String code, String parentId) {
        InsertInto insert = (InsertInto)((InsertInto)((InsertInto)new InsertInto(this.getTable("bos")).value("id", (Object)id)).value("code", (Object)code)).value("parentId", (Object)parentId);
        this.dc.executeUpdate((UpdateScript)insert);
    }

    private synchronized void insertBo(BoUp boUp) {
        this.insertBoTable(boUp.getId(), boUp.getCode(), boUp.getParentBoId());
        boUp.getRelationsList().forEach(rel -> {
            InsertInto insertRel = (InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)new InsertInto(this.getTable("rels")).value("id", (Object)rel.getId())).value("boId", (Object)rel.getBoId())).value("joinBoId", (Object)rel.getJoinBoId())).value("identity", (Object)rel.getIdentity())).value("relType", (Object)rel.getRelationType());
            this.dc.executeUpdate((UpdateScript)insertRel);
        });
        boUp.getApisList().forEach(api -> this.insertApi((Api)api, boUp.getId()));
        boUp.getFieldsList().forEach(field -> this.insertField((Field)field, boUp.getId()));
        boUp.getBoUpsList().stream().filter(relatedBo -> !this.findOneById("bos", relatedBo.getId()).isPresent()).forEach(relatedBo -> {
            this.insertBoTable(relatedBo.getId(), relatedBo.getCode(), relatedBo.getParentBoId());
            relatedBo.getApisList().forEach(api -> this.insertApi((Api)api, relatedBo.getId()));
            relatedBo.getFieldsList().forEach(field -> this.insertField((Field)field, relatedBo.getId()));
        });
    }

    private synchronized void insertField(Field field, String boId) {
        String editable = field.getEditable();
        String searchable = field.getSearchable();
        String identifier = field.getIdentifier();
        if ("1".equals(editable)) {
            editable = "true";
        }
        if ("1".equals(searchable)) {
            searchable = "true";
        }
        if ("1".equals(identifier)) {
            identifier = "true";
        }
        InsertInto insert = (InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)new InsertInto(this.getTable("fields")).value("boId", (Object)boId)).value("id", (Object)field.getId())).value("code", (Object)field.getCode())).value("displayType", (Object)field.getDisplayType())).value("editable", (Object)editable)).value("enumCode", (Object)field.getEnumCode())).value("maxLength", (Object)field.getMaxLength())).value("name", (Object)field.getName())).value("required", (Object)field.getRequired())).value("fieldType", (Object)field.getFieldType())).value("searchable", (Object)searchable)).value("dictId", (Object)field.getDictId())).value("defaultValue", (Object)field.getDefaultValue())).value("precision", (Object)String.valueOf(field.getPrecision()))).value("identifier", (Object)identifier)).value("validateRule", (Object)field.getValidateRule());
        this.dc.executeUpdate((UpdateScript)insert);
    }

    private synchronized void insertApi(Api api, String boId) {
        InsertInto insert = (InsertInto)((InsertInto)((InsertInto)((InsertInto)new InsertInto(this.getTable("apis")).value("boId", (Object)boId)).value("url", (Object)api.getUrl())).value("code", (Object)api.getCode())).value("method", (Object)api.getMethod());
        this.dc.executeUpdate((UpdateScript)insert);
    }

    private synchronized List<IEntityField> loadFields(String id) {
        DataSet fieldDs = ((SatisfiedWhereBuilder)this.dc.query().from("fields").selectAll().where("boId").eq(id)).execute();
        return fieldDs.toRows().stream().map(FieldHelper::toEntityClassField).collect(Collectors.toList());
    }

    private List<IEntityField> loadRelationField(List<Row> relations) {
        return relations.stream().filter(row -> RowUtils.getRowValue(row, "relType").map(String::valueOf).flatMap(FieldLikeRelationType::from).isPresent()).map(row -> {
            Optional<Row> joinBoOp = this.findOneById("bos", RowUtils.getRowValue(row, "joinBoId").map(String::valueOf).orElse(""));
            if (joinBoOp.isPresent()) {
                String code = joinBoOp.flatMap(x -> RowUtils.getRowValue(x, "code").map(String::valueOf)).orElse("");
                return FieldHelper.toEntityClassFieldFromRel(row, code);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

