/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.config.init;

import akka.japi.function.Creator;
import akka.japi.function.Procedure;
import akka.stream.ActorMaterializer;
import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.javadsl.Sink;
import com.xforceplus.ultraman.metadata.grpc.Base;
import com.xforceplus.ultraman.metadata.grpc.CheckServiceClient;
import com.xforceplus.ultraman.metadata.grpc.ModuleUpResult;
import com.xforceplus.ultraman.oqsengine.sdk.config.AuthSearcherConfig;
import com.xforceplus.ultraman.oqsengine.sdk.event.MetadataModuleGotEvent;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.MetadataRepository;
import com.xforceplus.xplat.galaxy.grpc.client.LongConnect;
import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;

public class ModuleInitService
implements SmartInitializingSingleton {
    private Logger logger = LoggerFactory.getLogger(ModuleInitService.class);
    @Autowired
    CheckServiceClient checkServiceClient;
    @Autowired
    private ActorMaterializer mat;
    @Autowired
    private AuthSearcherConfig config;
    @Autowired
    private ApplicationEventPublisher publisher;
    @Autowired
    MetadataRepository store;
    @Value(value="${xplat.oqsengine.sdk.init-size:5}")
    private Integer size;
    @Value(value="${xplat.oqsengine.sdk.init-time:10}")
    private Integer time;
    @Value(value="${xplat.oqsengine.sdk.init-timeout:30}")
    private Integer timeout;

    public void afterSingletonsInstantiated() {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Base.Authorization request = Base.Authorization.newBuilder().setAppId(this.config.getAppId()).setEnv(this.config.getEnv()).setTenantId(this.config.getTenant()).build();
        LongConnect.safeSource((int)2, (int)20, (Creator & Serializable)() -> this.checkServiceClient.checkStreaming(request)).log("ModuleService").groupedWithin(this.size.intValue(), Duration.ofSeconds(this.time.intValue())).runWith((Graph)Sink.foreach((Procedure & Serializable)x -> {
            this.logger.info("Got module size {}", (Object)x.size());
            MetadataModuleGotEvent event = new MetadataModuleGotEvent(request, (List<ModuleUpResult>)x);
            this.publisher.publishEvent((Object)event);
            this.logger.info("dispatched module ");
            if (countDownLatch.getCount() > 0L) {
                this.logger.info("first Modules lock count down");
                countDownLatch.countDown();
            }
        }), (Materializer)this.mat);
        this.logger.info("------- Waiting For Module init expected max module size {} max waiting time {}s-------", (Object)this.size, (Object)this.time);
        try {
            countDownLatch.await(this.timeout.intValue(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

