/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.config.init;

import akka.NotUsed;
import akka.japi.function.Creator;
import akka.japi.function.Function;
import akka.japi.function.Procedure;
import akka.stream.ActorMaterializer;
import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.javadsl.Sink;
import akka.stream.javadsl.Source;
import com.xforceplus.ultraman.metadata.grpc.NodeServiceClient;
import com.xforceplus.ultraman.metadata.grpc.NodeUp;
import com.xforceplus.ultraman.oqsengine.sdk.config.AuthSearcherConfig;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.CurrentVersion;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.MetadataRepository;
import com.xforceplus.xplat.common.utils.JsonHelper;
import com.xforceplus.xplat.galaxy.grpc.client.LongConnect;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class NodeReporterInitService
implements InitializingBean {
    @Autowired
    private NodeServiceClient nodeServiceClient;
    private Logger logger = LoggerFactory.getLogger(NodeReporterInitService.class);
    @Autowired
    private ActorMaterializer mat;
    @Autowired
    private AuthSearcherConfig config;
    @Value(value="${spring.application.name:default}")
    private String applicationName;
    @Autowired
    private MetadataRepository metadataRepository;

    public void afterPropertiesSet() throws Exception {
        Source reportSource = Source.tick((Duration)Duration.ZERO, (Duration)Duration.ofSeconds(30L), (Object)"report").map((Function & Serializable)x -> this.fetchCurrentNodeStatus()).mapMaterializedValue((Function & Serializable)m -> NotUsed.getInstance());
        LongConnect.safeSource((int)2, (int)20, (Creator & Serializable)() -> this.nodeServiceClient.report(reportSource)).log("NodeService").runWith((Graph)Sink.foreach((Procedure & Serializable)x -> this.logger.debug("Got reply at {}", (Object)LocalDateTime.now())), (Materializer)this.mat);
    }

    private NodeUp fetchCurrentNodeStatus() throws SocketException, UnknownHostException {
        Long appId = Long.parseLong(this.config.getAppId());
        Long envId = Long.parseLong(this.config.getEnv());
        String sdkVersion = this.getClass().getPackage().getImplementationVersion();
        System.out.println("show version" + sdkVersion);
        CurrentVersion currentVersion = this.metadataRepository.currentVersion();
        return NodeUp.newBuilder().setAppId(appId.longValue()).setEnvId(envId.longValue()).setCode(this.getNodeName()).setName(this.applicationName).setSdkVersion(Optional.ofNullable(sdkVersion).orElse("UNKNOWN-FROM-TEST")).setCurrentVersion(JsonHelper.toJsonStr((Object)currentVersion)).setStatus("OK").build();
    }

    private String getNodeName() throws SocketException, UnknownHostException {
        InetAddress inetAddress = InetAddress.getLocalHost();
        NetworkInterface byInetAddress = NetworkInterface.getByInetAddress(inetAddress);
        byte[] mac = byInetAddress.getHardwareAddress();
        String macName = null;
        if (mac != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < mac.length; ++i) {
                sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
            }
            macName = sb.toString();
        }
        return inetAddress.getHostAddress() + ":" + (String)Optional.ofNullable(macName).orElse("UNKNOWN");
    }
}

