/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.config.init;

import com.alibaba.fastjson.JSON;
import com.xforceplus.ultraman.oqsengine.pojo.auth.Authorization;
import com.xforceplus.ultraman.oqsengine.pojo.dto.UltForm;
import com.xforceplus.ultraman.oqsengine.sdk.config.AuthSearcherConfig;
import com.xforceplus.ultraman.oqsengine.sdk.config.ExternalServiceConfig;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.FormBoMapLocalStore;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.Response;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Order(value=2)
public class UltFormInitService
implements CommandLineRunner {
    final Logger logger = LoggerFactory.getLogger(UltFormInitService.class);
    @Autowired
    private AuthSearcherConfig config;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private FormBoMapLocalStore formBoMapLocalStore;

    public void run(String ... args) throws Exception {
        this.logger.info("begin init forms config");
        String accessUri = ExternalServiceConfig.PfcpAccessUri();
        String url = String.format("%s/forms/init", accessUri);
        Authorization auth = new Authorization();
        auth.setAppId(Long.valueOf(Long.parseLong(this.config.getAppId())));
        auth.setEnv(this.config.getEnv());
        Response result = new Response();
        try {
            HttpHeaders headers = new HttpHeaders();
            MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
            headers.setContentType(type);
            headers.add("Accept", MediaType.APPLICATION_JSON.toString());
            HttpEntity authorizeEntity = new HttpEntity((Object)auth, (MultiValueMap)headers);
            result = (Response)this.restTemplate.postForObject(url, (Object)authorizeEntity, Response.class, new Object[0]);
            if (result.getResult() != null) {
                List ultForms = (List)result.getResult();
                for (int i = 0; i < ultForms.size(); ++i) {
                    UltForm saveUltForm = (UltForm)JSON.parseObject((String)JSON.toJSONString(ultForms.get(i)), UltForm.class);
                    this.formBoMapLocalStore.save(saveUltForm);
                }
                this.logger.info("init forms config success");
            }
        }
        catch (Exception e) {
            this.logger.info("init forms config faild");
            throw new Exception(String.format("init forms config faild,The url is '%s'.", url));
        }
    }
}

