/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.handler;

import akka.japi.function.Function;
import akka.stream.ActorMaterializer;
import akka.stream.Graph;
import akka.stream.IOResult;
import akka.stream.Materializer;
import akka.stream.javadsl.Sink;
import akka.stream.javadsl.Source;
import akka.util.ByteString;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.EntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.Relation;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import com.xforceplus.ultraman.oqsengine.sdk.command.ConditionExportCmd;
import com.xforceplus.ultraman.oqsengine.sdk.command.ConditionSearchCmd;
import com.xforceplus.ultraman.oqsengine.sdk.command.GetImportTemplateCmd;
import com.xforceplus.ultraman.oqsengine.sdk.command.ImportCmd;
import com.xforceplus.ultraman.oqsengine.sdk.command.MetaDataLikeCmd;
import com.xforceplus.ultraman.oqsengine.sdk.command.SingleCreateCmd;
import com.xforceplus.ultraman.oqsengine.sdk.command.SingleDeleteCmd;
import com.xforceplus.ultraman.oqsengine.sdk.command.SingleQueryCmd;
import com.xforceplus.ultraman.oqsengine.sdk.command.SingleUpdateCmd;
import com.xforceplus.ultraman.oqsengine.sdk.event.EntityExported;
import com.xforceplus.ultraman.oqsengine.sdk.service.EntityService;
import com.xforceplus.ultraman.oqsengine.sdk.service.EntityServiceEx;
import com.xforceplus.ultraman.oqsengine.sdk.service.ExportSink;
import com.xforceplus.ultraman.oqsengine.sdk.service.ExportSource;
import com.xforceplus.ultraman.oqsengine.sdk.ui.DefaultUiService;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.DictItem;
import com.xforceplus.xplat.galaxy.framework.dispatcher.anno.QueryHandler;
import com.xforceplus.xplat.galaxy.framework.dispatcher.messaging.MetaData;
import com.xforceplus.xplat.galaxy.framework.dispatcher.messaging.QueryMessage;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class DefaultEntityServiceHandler
implements DefaultUiService {
    @Autowired
    private EntityService entityService;
    @Autowired
    private ExportSource exportService;
    @Autowired
    private ExportSink exportSink;
    @Autowired
    private EntityServiceEx entityServiceEx;
    @Autowired
    private ActorMaterializer materializer;
    @Autowired
    private ApplicationEventPublisher publisher;
    private static final String MISSING_ENTITIES = "\u67e5\u8be2\u5bf9\u8c61\u4e0d\u5b58\u5728";
    private Logger log = LoggerFactory.getLogger(DefaultUiService.class);

    private Optional<EntityClass> getEntityClass(MetaDataLikeCmd cmd) {
        return Optional.ofNullable(cmd.version()).map(x -> this.entityService.load(cmd.getBoId(), cmd.version())).orElseGet(() -> this.entityService.load(cmd.getBoId()));
    }

    @Override
    @QueryHandler(isDefault=true)
    public Either<String, Map<String, Object>> singleQuery(SingleQueryCmd cmd) {
        Optional<EntityClass> entityClassOp = this.getEntityClass(cmd);
        if (entityClassOp.isPresent()) {
            return this.entityService.findOne((IEntityClass)entityClassOp.get(), Long.parseLong(cmd.getId()));
        }
        return Either.left((Object)MISSING_ENTITIES);
    }

    @Override
    @QueryHandler(isDefault=true)
    public Either<String, Integer> singleDelete(SingleDeleteCmd cmd) {
        Optional<EntityClass> entityClassOp = this.getEntityClass(cmd);
        if (entityClassOp.isPresent()) {
            return this.entityService.deleteOne((IEntityClass)entityClassOp.get(), Long.valueOf(cmd.getId()));
        }
        return Either.left((Object)MISSING_ENTITIES);
    }

    @Override
    @QueryHandler(isDefault=true)
    public Either<String, Long> singleCreate(SingleCreateCmd cmd) {
        Optional<EntityClass> entityClassOp = this.getEntityClass(cmd);
        if (entityClassOp.isPresent()) {
            return this.entityService.create((IEntityClass)entityClassOp.get(), cmd.getBody());
        }
        return Either.left((Object)MISSING_ENTITIES);
    }

    @Override
    @QueryHandler(isDefault=true)
    public Either<String, Integer> singleUpdate(SingleUpdateCmd cmd) {
        Optional<EntityClass> entityClassOp = this.getEntityClass(cmd);
        if (entityClassOp.isPresent()) {
            return this.entityService.updateById((IEntityClass)entityClassOp.get(), cmd.getId(), cmd.getBody());
        }
        return Either.left((Object)MISSING_ENTITIES);
    }

    @Override
    @QueryHandler(isDefault=true)
    public Either<String, Tuple2<Integer, List<Map<String, Object>>>> conditionSearch(ConditionSearchCmd cmd) {
        Optional<EntityClass> entityClassOp = this.getEntityClass(cmd);
        if (entityClassOp.isPresent()) {
            return this.entityService.findByCondition((IEntityClass)entityClassOp.get(), cmd.getConditionQueryRequest());
        }
        return Either.left((Object)MISSING_ENTITIES);
    }

    @Override
    @QueryHandler(isDefault=true)
    public CompletableFuture<Either<String, String>> conditionExport(QueryMessage<ConditionExportCmd, ?> message) {
        ConditionExportCmd cmd = (ConditionExportCmd)message.getPayload();
        MetaData metaData = message.getMetaData();
        AtomicBoolean isFirstLine = new AtomicBoolean(true);
        String token = Optional.ofNullable(metaData.get((Object)"name")).map(Object::toString).orElse(Optional.ofNullable(metaData.get((Object)"code")).map(Object::toString).orElse(cmd.getBoId())) + "-" + System.nanoTime();
        Sink<ByteString, CompletionStage<Tuple2<IOResult, String>>> fileSink = this.exportSink.getSink(token);
        ConditionQueryRequest request = cmd.getConditionQueryRequest();
        Set<String> keys = request.getStringKeys();
        HashMap mapping = new HashMap();
        HashMap searchTable = new HashMap();
        Optional<EntityClass> iEntityClassOp = cmd.getBoId() != null ? this.entityService.load(cmd.getBoId()) : this.entityService.load(cmd.getBoId(), cmd.version());
        if (!iEntityClassOp.isPresent()) {
            return CompletableFuture.completedFuture(Either.left((Object)MISSING_ENTITIES));
        }
        IEntityClass entityClass = (IEntityClass)iEntityClassOp.get();
        byte[] bom = new byte[]{-17, -69, -65};
        Source bomSource = Source.single((Object)ByteString.fromArray((byte[])bom));
        Source content = this.exportService.source(entityClass, cmd.getConditionQueryRequest()).map((Function & Serializable)record -> {
            StringBuilder sb = new StringBuilder();
            if (isFirstLine.get()) {
                String header = record.stream(keys).map(Tuple2::_1).map(x -> Optional.ofNullable(x).map(IEntityField::cnName).orElse("")).collect(Collectors.joining(","));
                sb.append(header);
                sb.append("\n");
                isFirstLine.set(false);
            }
            String line = record.stream(keys).map(x -> {
                IEntityField field = (IEntityField)x._1();
                Object value = x._2();
                return "\"\t" + this.getString(entityClass, field, value, mapping, searchTable) + "\"";
            }).collect(Collectors.joining(","));
            sb.append(line);
            sb.append("\n");
            return sb.toString();
        }).map((Function & Serializable)x -> ByteString.fromString((String)x, (Charset)StandardCharsets.UTF_8));
        return ((CompletionStage)bomSource.concat((Graph)content).runWith(fileSink, (Materializer)this.materializer)).toCompletableFuture().thenApply(x -> {
            String downloadUrl = this.exportSink.getDownloadUrl((String)x._2());
            HashMap<String, Object> context = new HashMap<String, Object>();
            if (metaData != null) {
                context.putAll((Map<String, Object>)metaData);
            }
            this.publisher.publishEvent((Object)new EntityExported(context, downloadUrl, token));
            return Either.right((Object)downloadUrl);
        });
    }

    @Override
    @QueryHandler(isDefault=true)
    public Either<String, InputStream> importTemplate(GetImportTemplateCmd cmd) {
        String boId = cmd.getBoId();
        Optional<EntityClass> entityClass = this.entityService.load(boId);
        if (entityClass.isPresent()) {
            List fields = entityClass.get().fields();
            String columns = fields.stream().map(IEntityField::name).collect(Collectors.joining(","));
            return Either.right((Object)new ByteArrayInputStream(columns.getBytes(StandardCharsets.UTF_8)));
        }
        return Either.left((Object)MISSING_ENTITIES);
    }

    @Override
    @QueryHandler(isDefault=true)
    public Either<String, String> batchImport(ImportCmd cmd) {
        String boId = cmd.getBoId();
        Optional<EntityClass> entityClassOp = this.entityService.load(boId);
        if (entityClassOp.isPresent()) {
            Either<String, String> ret;
            MultipartFile file = cmd.getFile();
            try {
                CSVParser parser = CSVParser.parse((InputStream)file.getInputStream(), (Charset)StandardCharsets.UTF_8, (CSVFormat)CSVFormat.EXCEL);
                List list = parser.getRecords();
                HashMap map = new HashMap();
                if (list.size() > 1) {
                    CSVRecord header = (CSVRecord)list.get(0);
                    ret = this.entityService.transactionalExecute(() -> {
                        for (int i = 1; i < list.size(); ++i) {
                            CSVRecord record = (CSVRecord)list.get(i);
                            for (int j = 0; j < header.size(); ++j) {
                                map.put(header.get(j), StringUtils.isEmpty((Object)record.get(j)) ? null : record.get(j));
                                this.entityService.create((IEntityClass)entityClassOp.get(), map);
                            }
                        }
                        return "ok";
                    });
                } else {
                    ret = Either.right((Object)"ok");
                }
                parser.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                ret = Either.left((Object)e.getMessage());
            }
            return ret;
        }
        return Either.left((Object)MISSING_ENTITIES);
    }

    private String getString(IEntityClass entityClass, IEntityField entityField, Object value, Map<String, List<DictItem>> mapping, Map<String, Map<String, String>> searchTable) {
        FieldType type = entityField.type();
        String retStr = null;
        String safeSourceValue = Optional.ofNullable(value).map(Object::toString).orElse("");
        switch (type) {
            case ENUM: {
                String dictId = entityField.dictId();
                List<DictItem> items = mapping.get(dictId);
                if (items == null) {
                    List<DictItem> dictItems = this.entityServiceEx.findDictItems(dictId, null);
                    mapping.put(dictId, dictItems);
                    items = dictItems;
                }
                retStr = items.stream().filter(x -> x.getValue().equals(safeSourceValue)).map(DictItem::getText).findAny().orElse("unknown");
                break;
            }
            case STRINGS: {
                Optional<EntityClass> relatedEntityOp;
                String[] ids = safeSourceValue.split(",");
                Long fieldId = entityField.id();
                Optional<Long> relatedId = entityClass.relations().stream().filter(x -> x.getEntityField() != null).filter(x -> x.getEntityField().id() == fieldId.longValue()).map(Relation::getEntityClassId).findAny();
                if (!relatedId.isPresent() || !(relatedEntityOp = this.entityService.load(relatedId.get().toString())).isPresent()) break;
                IEntityClass relatedEntity = (IEntityClass)relatedEntityOp.get();
                Map<String, String> cachedList = searchTable.get(relatedId.get().toString());
                if (cachedList == null) {
                    HashMap<String, String> cached = new HashMap<String, String>();
                    searchTable.put(relatedId.get().toString(), cached);
                    cachedList = cached;
                }
                Map<String, String> finalCachedList = cachedList;
                Optional<IEntityField> displayField = relatedEntity.fields().stream().filter(x -> Optional.ofNullable(x.config()).filter(field -> "1".equals(field.getDisplayType())).isPresent()).findFirst();
                retStr = Stream.of(ids).map(x -> {
                    String name = (String)finalCachedList.get(x);
                    String innerRetStr = x;
                    if (name == null) {
                        if (displayField.isPresent()) {
                            try {
                                Either<String, Map<String, Object>> one = this.entityService.findOne(relatedEntity, Long.parseLong(x));
                                if (one.isRight()) {
                                    String key = ((IEntityField)displayField.get()).name();
                                    Object relatedDisplayName = ((Map)one.get()).get(key);
                                    if (relatedDisplayName != null) {
                                        innerRetStr = relatedDisplayName.toString();
                                    }
                                }
                            }
                            catch (Exception ex) {
                                this.log.error("{}", (Throwable)ex);
                            }
                        }
                        finalCachedList.put((String)x, innerRetStr);
                    } else {
                        innerRetStr = name;
                    }
                    return innerRetStr;
                }).collect(Collectors.joining(","));
                break;
            }
            default: {
                retStr = entityField.type().toTypedValue(entityField, safeSourceValue).map(IValue::getValue).map(Object::toString).orElse("");
            }
        }
        return retStr;
    }
}

