/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.listener;

import com.xforcecloud.noification.model.BaseResponse;
import com.xforcecloud.noification.model.MessageInfo;
import com.xforcecloud.noification.model.Scope;
import com.xforceplus.ultraman.oqsengine.sdk.event.EntityExported;
import com.xforceplus.xplat.galaxy.framework.context.ContextKeys;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.stringtemplate.v4.ST;

public class MessageCenterEntityExportEventListener {
    private Supplier<String> tokenSupplier;
    private String senderId;
    private String gatewayUrl;
    private String titleTemplate;
    private String contentTemplate;
    private final RestTemplate restTemplate;
    private String routePattern = "%s/api/%s/message/v1/messages?appId=%s";
    private Logger logger = LoggerFactory.getLogger(MessageCenterEntityExportEventListener.class);
    private ST content;
    private ST title;
    private final String defaultContentStr = "<a href='$downloadUrl$'>$fileName$</a>";
    private ST defaultContent = new ST("<a href='$downloadUrl$'>$fileName$</a>", '$', '$');

    public MessageCenterEntityExportEventListener(Supplier<String> tokenSupplier, Supplier<String> senderIdSupplier, Supplier<String> gatewayUrl, String contentTemplate, String titleTemplate, RestTemplate restTemplate) {
        this.tokenSupplier = tokenSupplier;
        this.senderId = senderIdSupplier.get();
        this.gatewayUrl = gatewayUrl.get();
        this.restTemplate = restTemplate;
        this.contentTemplate = contentTemplate != null ? contentTemplate : "<a href='$downloadUrl$'>$fileName$</a>";
        this.titleTemplate = titleTemplate != null ? titleTemplate : "\u5bfc\u51fa\u4e0b\u8f7d";
        this.content = new ST(this.contentTemplate, '$', '$');
        this.title = new ST(this.titleTemplate, '$', '$');
    }

    @Async
    @EventListener(value={EntityExported.class})
    public void sendToMessage(EntityExported entityExported) {
        Map<String, Object> context = entityExported.getContext();
        if (context != null) {
            Object tenantIdObj = context.get(ContextKeys.LongKeys.TENANT_ID.name());
            Object userId = context.get(ContextKeys.LongKeys.ACCOUNT_ID.name());
            if (tenantIdObj != null) {
                Long tenantId = (Long)tenantIdObj;
                MessageInfo messageInfo = new MessageInfo();
                String downloadUrl = entityExported.getDownloadUrl();
                String fileName = entityExported.getFileName();
                messageInfo.setScope(Scope.SINGLE);
                messageInfo.setTitle(this.getRendered(this.title, fileName, downloadUrl, () -> "\u5bfc\u51fa\u6210\u529f"));
                messageInfo.setContent(this.getRendered(this.content, fileName, downloadUrl, () -> this.getRendered(this.defaultContent, downloadUrl, fileName, () -> "\u4e0b\u8f7d\u5730\u5740")));
                messageInfo.setReceiverIds(Arrays.asList((Long)userId));
                messageInfo.setType(Integer.valueOf(0));
                HttpHeaders headers = new HttpHeaders();
                MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
                headers.setContentType(type);
                headers.add("Accept", MediaType.APPLICATION_JSON.toString());
                headers.add("x-app-token", this.tokenSupplier.get());
                HttpEntity messageEntity = new HttpEntity((Object)messageInfo, (MultiValueMap)headers);
                String url = String.format(this.routePattern, this.gatewayUrl, tenantId, this.senderId);
                try {
                    ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)messageEntity, BaseResponse.class, new Object[0]);
                }
                catch (RuntimeException ex) {
                    this.logger.error("{}", (Throwable)ex);
                }
            }
        }
    }

    private String getRendered(ST st, String fileName, String downloadUrl, Supplier<String> fallbackStr) {
        try {
            st.add("downloadUrl", (Object)downloadUrl);
            st.add("fileName", (Object)fileName);
            return st.render();
        }
        catch (Exception ex) {
            this.logger.error("{}", (Throwable)ex);
            return fallbackStr.get();
        }
    }
}

