/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.listener;

import com.xforceplus.ultraman.metadata.grpc.Base;
import com.xforceplus.ultraman.metadata.grpc.CheckServiceClient;
import com.xforceplus.ultraman.metadata.grpc.ModuleUp;
import com.xforceplus.ultraman.metadata.grpc.ModuleUpResult;
import com.xforceplus.ultraman.oqsengine.sdk.config.AuthSearcherConfig;
import com.xforceplus.ultraman.oqsengine.sdk.event.MetadataModuleGotEvent;
import com.xforceplus.ultraman.oqsengine.sdk.event.MetadataModuleVersionMissingEvent;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.MetadataRepository;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;

public class ModuleEventListener {
    @Autowired
    private MetadataRepository store;
    @Autowired
    private CheckServiceClient checkServiceClient;
    @Autowired
    private AuthSearcherConfig config;
    @Autowired
    private MetadataRepository repository;
    Logger logger = LoggerFactory.getLogger(ModuleEventListener.class);

    @Async
    @EventListener(value={MetadataModuleGotEvent.class})
    public void saveMetadata(MetadataModuleGotEvent event) {
        List moduleUpResults = Optional.ofNullable(event.getResponse()).orElseGet(Collections::emptyList);
        moduleUpResults.forEach(module -> {
            this.logger.debug("Got Module {}", (Object)event);
            this.store.save((ModuleUpResult)module, event.getRequest().getTenantId(), event.getRequest().getAppId());
            this.logger.info("Module {}:{} saved ", (Object)module.getId(), (Object)module.getCode());
        });
    }

    @Async
    @EventListener(value={MetadataModuleVersionMissingEvent.class})
    public void requestMetadata(MetadataModuleVersionMissingEvent event) {
        this.logger.debug("Got Module Missing {}", (Object)event);
        Base.Authorization request = Base.Authorization.newBuilder().setAppId(this.config.getAppId()).setEnv(this.config.getEnv()).setTenantId(this.config.getTenant()).build();
        Long module = event.getModuleId();
        String version = event.getVersion();
        ModuleUpResult result = (ModuleUpResult)this.checkServiceClient.check(ModuleUp.newBuilder().setModuleId(module.toString()).setModuleVersion(version).addAuthorization(request).build()).toCompletableFuture().join();
        this.logger.debug("Got Versioned Module {}", (Object)result);
        this.repository.save(result, this.config.getTenant(), this.config.getAppId());
        this.logger.debug("Versioned Module saved {}", (Object)Optional.ofNullable(result).map(x -> x.getVersion()).orElseGet(() -> "none"));
    }
}

