/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.impl;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.reader.IEntityClassReader;
import com.xforceplus.ultraman.oqsengine.sdk.ConditionsUp;
import com.xforceplus.ultraman.oqsengine.sdk.FieldConditionUp;
import com.xforceplus.ultraman.oqsengine.sdk.service.HandleQueryValueService;
import com.xforceplus.ultraman.oqsengine.sdk.service.OperationType;
import com.xforceplus.ultraman.oqsengine.sdk.service.operation.QuerySideFieldOperationHandler;
import com.xforceplus.ultraman.oqsengine.sdk.service.operation.TriFunction;
import com.xforceplus.ultraman.oqsengine.sdk.util.EntityClassToGrpcConverter;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.Conditions;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.FieldCondition;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHandleQueryValueService
implements HandleQueryValueService {
    private Logger logger = LoggerFactory.getLogger(HandleQueryValueService.class);
    final List<QuerySideFieldOperationHandler> querySideFieldOperationHandler;

    public DefaultHandleQueryValueService(List<QuerySideFieldOperationHandler> querySideFieldOperationHandler) {
        this.querySideFieldOperationHandler = querySideFieldOperationHandler;
    }

    @Override
    public ConditionsUp handleQueryValue(IEntityClass entityClass, Conditions conditions, OperationType phase) {
        ConditionsUp.Builder conditionsUpBuilder = ConditionsUp.newBuilder();
        IEntityClassReader reader = new IEntityClassReader(entityClass, new IEntityClass[0]);
        Stream subFieldConditionStream = Optional.ofNullable(conditions).map(Conditions::getEntities).orElseGet(Collections::emptyList).stream().flatMap(x -> x.getFields().stream().map(field -> Tuple.of((Object)x.getCode(), (Object)field)));
        Stream<Tuple2> fieldConditionStream = Optional.ofNullable(conditions).map(Conditions::getFields).orElseGet(Collections::emptyList).stream().map(x -> Tuple.of((Object)"", (Object)x));
        List fieldConditionUps = Stream.concat(fieldConditionStream, subFieldConditionStream).map(x -> {
            String code = (String)x._1();
            FieldCondition fieldCondition = (FieldCondition)x._2();
            String combinedName = StringUtils.isEmpty((CharSequence)code) ? fieldCondition.getCode() : code + "." + fieldCondition.getCode();
            Optional fieldOp = reader.column(combinedName);
            return fieldOp.map(field -> FieldConditionUp.newBuilder().setCode(field.name()).setOperation(FieldConditionUp.Op.valueOf((String)fieldCondition.getOperation().name())).addAllValues(this.doHandle((IEntityField)field, fieldCondition.getValue())).setField(EntityClassToGrpcConverter.toFieldUp(field)).build());
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        conditionsUpBuilder.addAllFields(fieldConditionUps);
        return conditionsUpBuilder.build();
    }

    private List<String> doHandle(IEntityField field, List<String> origin) {
        return Optional.ofNullable(origin).orElseGet(Collections::emptyList).stream().filter(Objects::nonNull).map(input -> this.pipeline(input, field, OperationType.QUERY)).filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList());
    }

    private Object pipeline(Object value, IEntityField field, OperationType phase) {
        try {
            return this.querySideFieldOperationHandler.stream().sorted().map(x -> x).reduce(TriFunction::andThen).map(x -> x.apply(field, value, phase)).orElse(value);
        }
        catch (Exception ex) {
            this.logger.error("{}", (Throwable)ex);
            return null;
        }
    }
}

