/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.impl;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.reader.IEntityClassReader;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.Record;
import com.xforceplus.ultraman.oqsengine.sdk.EntityUp;
import com.xforceplus.ultraman.oqsengine.sdk.ValueUp;
import com.xforceplus.ultraman.oqsengine.sdk.service.HandleResultValueService;
import com.xforceplus.ultraman.oqsengine.sdk.service.OperationType;
import com.xforceplus.ultraman.oqsengine.sdk.service.operation.RecordOperationHandler;
import com.xforceplus.ultraman.oqsengine.sdk.service.operation.ResultSideOperationHandler;
import com.xforceplus.ultraman.oqsengine.sdk.service.operation.TriFunction;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHandleResultValueService
implements HandleResultValueService {
    private Logger logger = LoggerFactory.getLogger(HandleResultValueService.class);
    final List<RecordOperationHandler> handlers;
    final List<ResultSideOperationHandler> resultSideOperationHandlers;

    public DefaultHandleResultValueService(List<RecordOperationHandler> handlers, List<ResultSideOperationHandler> resultSideOperationHandlers) {
        this.handlers = handlers;
        this.resultSideOperationHandlers = resultSideOperationHandlers;
    }

    @Override
    public Record toRecord(IEntityClass entityClass, EntityUp up) {
        IEntityClassReader reader = new IEntityClassReader(entityClass, new IEntityClass[0]);
        Map<String, Object> retValue = up.getValuesList().stream().collect(Collectors.toMap(ValueUp::getName, ValueUp::getValue));
        Record record = reader.toRecord(retValue);
        this.pipeConsumer(record, up);
        record.stream().forEach(tuple -> record.set((IEntityField)tuple._1(), this.pipeline(tuple._2(), (IEntityField)tuple._1(), OperationType.RESULT)));
        return record;
    }

    private Object pipeline(Object value, IEntityField field, OperationType phase) {
        try {
            return this.resultSideOperationHandlers.stream().sorted().map(x -> x).reduce(TriFunction::andThen).map(x -> x.apply(field, value, phase)).orElse(value);
        }
        catch (Exception ex) {
            this.logger.error("{}", (Throwable)ex);
            return null;
        }
    }

    private void pipeConsumer(Record record, EntityUp entityUp) {
        this.handlers.stream().sorted().map(x -> x).reduce(BiConsumer::andThen).ifPresent(x -> x.accept(record, entityUp));
    }
}

