/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.impl;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.reader.IEntityClassReader;
import com.xforceplus.ultraman.oqsengine.sdk.ValueUp;
import com.xforceplus.ultraman.oqsengine.sdk.service.HandleValueService;
import com.xforceplus.ultraman.oqsengine.sdk.service.OperationType;
import com.xforceplus.ultraman.oqsengine.sdk.service.operation.FieldOperationHandler;
import com.xforceplus.ultraman.oqsengine.sdk.service.operation.TriFunction;
import com.xforceplus.ultraman.oqsengine.sdk.service.operation.validator.FieldValidator;
import io.vavr.control.Validation;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHandleValueService
implements HandleValueService {
    private Logger logger = LoggerFactory.getLogger(HandleValueService.class);
    private final List<FieldOperationHandler> fieldOperationHandlers;
    private final List<FieldValidator<Object>> fieldValidators;

    public DefaultHandleValueService(List<FieldOperationHandler> fieldOperationHandlers, List<FieldValidator<Object>> fieldValidator) {
        this.fieldOperationHandlers = fieldOperationHandlers;
        this.fieldValidators = fieldValidator;
    }

    @Override
    public List<ValueUp> handlerValue(IEntityClass entityClass, Map<String, Object> body, OperationType phase) {
        IEntityClassReader reader = new IEntityClassReader(entityClass, new IEntityClass[0]);
        List<ValueUp> values = reader.zipValue(body).map(tuple -> {
            Object obj;
            Object value;
            IEntityField field = (IEntityField)tuple._1();
            List<Validation<String, Object>> validations = this.validate(field, value = this.pipeline(obj = tuple._2(), field, phase), phase);
            if (!validations.isEmpty()) {
                throw new RuntimeException(validations.stream().map(Validation::getError).collect(Collectors.joining(",")));
            }
            if (value != null) {
                return ValueUp.newBuilder().setFieldId(field.id()).setFieldType(field.type().getType()).setValue(value.toString()).build();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return values;
    }

    private Object pipeline(Object value, IEntityField field, OperationType phase) {
        return this.fieldOperationHandlers.stream().sorted().map(x -> x).reduce(TriFunction::andThen).map(x -> x.apply(field, value, phase)).orElse(value);
    }

    private List<Validation<String, Object>> validate(IEntityField field, Object obj, OperationType phase) {
        return this.fieldValidators.stream().map(x -> x.validate(field, obj, phase)).filter(Validation::isInvalid).collect(Collectors.toList());
    }
}

