/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.impl;

import akka.grpc.javadsl.SingleResponseRequestBuilder;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.EntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.Record;
import com.xforceplus.ultraman.oqsengine.sdk.ConditionsUp;
import com.xforceplus.ultraman.oqsengine.sdk.EntityServiceClient;
import com.xforceplus.ultraman.oqsengine.sdk.EntityUp;
import com.xforceplus.ultraman.oqsengine.sdk.OperationResult;
import com.xforceplus.ultraman.oqsengine.sdk.TransactionUp;
import com.xforceplus.ultraman.oqsengine.sdk.ValueUp;
import com.xforceplus.ultraman.oqsengine.sdk.event.EntityCreated;
import com.xforceplus.ultraman.oqsengine.sdk.event.EntityDeleted;
import com.xforceplus.ultraman.oqsengine.sdk.event.EntityUpdated;
import com.xforceplus.ultraman.oqsengine.sdk.service.EntityService;
import com.xforceplus.ultraman.oqsengine.sdk.service.HandleQueryValueService;
import com.xforceplus.ultraman.oqsengine.sdk.service.HandleResultValueService;
import com.xforceplus.ultraman.oqsengine.sdk.service.HandleValueService;
import com.xforceplus.ultraman.oqsengine.sdk.service.OperationType;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.MetadataRepository;
import com.xforceplus.ultraman.oqsengine.sdk.util.EntityClassToGrpcConverter;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionQueryRequest;
import com.xforceplus.xplat.galaxy.framework.context.ContextKeys;
import com.xforceplus.xplat.galaxy.framework.context.ContextService;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.util.StringUtils;

public class EntityServiceImpl
implements EntityService {
    private final MetadataRepository metadataRepository;
    private final EntityServiceClient entityServiceClient;
    private final ContextService contextService;
    @Autowired
    private ApplicationEventPublisher publisher;
    @Autowired
    private HandleValueService handlerValueService;
    @Autowired
    private HandleQueryValueService handleQueryValueService;
    @Autowired
    private HandleResultValueService handleResultValueService;

    public EntityServiceImpl(MetadataRepository metadataRepository, EntityServiceClient entityServiceClient, ContextService contextService) {
        this.metadataRepository = metadataRepository;
        this.entityServiceClient = entityServiceClient;
        this.contextService = contextService;
    }

    @Override
    public Optional<EntityClass> load(String boId) {
        String tenantId = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTID_KEY);
        String appCode = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.APPCODE);
        return this.metadataRepository.load(tenantId, appCode, boId);
    }

    @Override
    public Optional<EntityClass> load(String boId, String version) {
        String tenantId = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTID_KEY);
        String appCode = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.APPCODE);
        return this.metadataRepository.load(tenantId, appCode, boId, version);
    }

    @Override
    public Optional<EntityClass> loadByCode(String bocode) {
        String tenantId = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTID_KEY);
        String appCode = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.APPCODE);
        return this.metadataRepository.loadByCode(tenantId, appCode, bocode);
    }

    @Override
    public Optional<EntityClass> loadByCode(String bocode, String version) {
        String tenantId = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTID_KEY);
        String appCode = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.APPCODE);
        return this.metadataRepository.loadByCode(tenantId, appCode, bocode, version);
    }

    @Override
    public <T> Either<String, T> transactionalExecute(Callable<T> supplier) {
        OperationResult result = (OperationResult)this.entityServiceClient.begin(TransactionUp.newBuilder().build()).toCompletableFuture().join();
        if (result.getCode() == OperationResult.Code.OK) {
            this.contextService.set((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY, (Object)result.getTransactionResult());
            try {
                Object t = supplier.call();
                CompletableFuture<Object> commitedT = this.entityServiceClient.commit(TransactionUp.newBuilder().setId(result.getTransactionResult()).build()).thenApply(x -> {
                    if (x.getCode() == OperationResult.Code.OK) {
                        return t;
                    }
                    throw new RuntimeException("\u4e8b\u52a1\u63d0\u4ea4\u5931\u8d25");
                }).toCompletableFuture();
                if (commitedT.isCompletedExceptionally()) {
                    return Either.left((Object)"\u4e8b\u52a1\u63d0\u4ea4\u5931\u8d25");
                }
                return Either.right((Object)commitedT.join());
            }
            catch (Exception ex) {
                this.entityServiceClient.rollBack(TransactionUp.newBuilder().setId(result.getTransactionResult()).build());
                return Either.left((Object)ex.getMessage());
            }
        }
        return Either.left((Object)"\u4e8b\u52a1\u521b\u5efa\u5931\u8d25");
    }

    @Override
    public Either<String, Map<String, Object>> findOne(IEntityClass entityClass, long id) {
        OperationResult queryResult;
        String transId = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY);
        SingleResponseRequestBuilder queryResultBuilder = this.entityServiceClient.selectOne();
        if (transId != null) {
            queryResultBuilder.addHeader("transaction-id", transId);
        }
        if ((queryResult = (OperationResult)queryResultBuilder.invoke((Object)EntityClassToGrpcConverter.toEntityUp(entityClass, id)).toCompletableFuture().join()).getCode() == OperationResult.Code.OK) {
            if (queryResult.getTotalRow() > 0) {
                return Either.right((Object)this.handleResultValueService.toRecord(entityClass, (EntityUp)queryResult.getQueryResultList().get(0)).toMap(null));
            }
            return Either.left((Object)"\u672a\u67e5\u8be2\u5230\u8bb0\u5f55");
        }
        return Either.left((Object)queryResult.getMessage());
    }

    @Override
    public Either<String, Integer> deleteOne(IEntityClass entityClass, Long id) {
        OperationResult updateResult;
        String transId = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY);
        SingleResponseRequestBuilder removeBuilder = this.entityServiceClient.remove();
        if (transId != null) {
            removeBuilder.addHeader("transaction-id", transId);
        }
        if ((updateResult = (OperationResult)removeBuilder.invoke((Object)EntityClassToGrpcConverter.toEntityUp(entityClass, id)).toCompletableFuture().join()).getCode() == OperationResult.Code.OK) {
            int rows = updateResult.getAffectedRow();
            if (rows > 0) {
                this.publisher.publishEvent((Object)this.buildDeleteEvent(entityClass, id));
            }
            return Either.right((Object)rows);
        }
        return Either.left((Object)updateResult.getMessage());
    }

    private Map<String, String> getContext() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(ContextKeys.StringKeys.TENANTID_KEY.name(), (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTID_KEY));
        map.put(ContextKeys.StringKeys.TENANTCODE_KEY.name(), (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTCODE_KEY));
        map.put(ContextKeys.StringKeys.USERNAME.name(), (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.USERNAME));
        map.put(ContextKeys.StringKeys.USER_DISPLAYNAME.name(), (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.USER_DISPLAYNAME));
        return map;
    }

    @Override
    public Either<String, Integer> updateById(IEntityClass entityClass, Long id, Map<String, Object> body) {
        String transId = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY);
        SingleResponseRequestBuilder replaceBuilder = this.entityServiceClient.replace();
        if (transId != null) {
            replaceBuilder.addHeader("transaction-id", transId);
        }
        List<ValueUp> valueUps = this.handlerValueService.handlerValue(entityClass, body, OperationType.UPDATE);
        OperationResult updateResult = (OperationResult)this.entityServiceClient.replace().invoke((Object)EntityClassToGrpcConverter.toEntityUp(entityClass, id, valueUps)).toCompletableFuture().join();
        if (updateResult.getCode() == OperationResult.Code.OK) {
            int rows = updateResult.getAffectedRow();
            if (rows > 0) {
                this.publisher.publishEvent((Object)this.buildUpdatedEvent(entityClass, id, body));
            }
            return Either.right((Object)rows);
        }
        return Either.left((Object)updateResult.getMessage());
    }

    @Override
    public Either<String, Integer> replaceById(IEntityClass entityClass, Long id, Map<String, Object> body) {
        String transId = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY);
        SingleResponseRequestBuilder replaceBuilder = this.entityServiceClient.replace();
        if (transId != null) {
            replaceBuilder.addHeader("transaction-id", transId);
        }
        replaceBuilder.addHeader("mode", "replace");
        List<ValueUp> valueUps = this.handlerValueService.handlerValue(entityClass, body, OperationType.REPLACE);
        OperationResult updateResult = (OperationResult)this.entityServiceClient.replace().invoke((Object)EntityClassToGrpcConverter.toEntityUp(entityClass, id, valueUps)).toCompletableFuture().join();
        if (updateResult.getCode() == OperationResult.Code.OK) {
            int rows = updateResult.getAffectedRow();
            if (rows > 0) {
                this.publisher.publishEvent((Object)this.buildUpdatedEvent(entityClass, id, body));
            }
            return Either.right((Object)rows);
        }
        return Either.left((Object)updateResult.getMessage());
    }

    @Override
    public Either<String, Tuple2<Integer, List<Record>>> findRecordsByCondition(IEntityClass entityClass, List<Long> ids, ConditionQueryRequest condition) {
        ConditionsUp conditionsUp;
        OperationResult result;
        String transId = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY);
        SingleResponseRequestBuilder requestBuilder = this.entityServiceClient.selectByConditions();
        if (transId != null) {
            requestBuilder.addHeader("transaction-id", transId);
        }
        if ((result = (OperationResult)requestBuilder.invoke((Object)EntityClassToGrpcConverter.toSelectByCondition(entityClass, ids, condition, conditionsUp = Optional.ofNullable(condition).map(ConditionQueryRequest::getConditions).map(x -> this.handleQueryValueService.handleQueryValue(entityClass, condition.getConditions(), OperationType.QUERY)).orElseGet(() -> ConditionsUp.newBuilder().build()))).toCompletableFuture().join()).getCode() == OperationResult.Code.OK) {
            List repList = result.getQueryResultList().stream().map(x -> this.handleResultValueService.toRecord(entityClass, (EntityUp)x)).collect(Collectors.toList());
            Tuple2 queryResult = Tuple.of((Object)result.getTotalRow(), repList);
            return Either.right((Object)queryResult);
        }
        return Either.left((Object)result.getMessage());
    }

    @Override
    public Either<String, Tuple2<Integer, List<Map<String, Object>>>> findByCondition(IEntityClass entityClass, ConditionQueryRequest condition) {
        return this.findByConditionWithIds(entityClass, null, condition);
    }

    @Override
    public Either<String, Tuple2<Integer, List<Map<String, Object>>>> findByConditionWithIds(IEntityClass entityClass, List<Long> ids, ConditionQueryRequest condition) {
        return this.findRecordsByCondition(entityClass, ids, condition).map(tuple -> {
            List mapResult = ((List)tuple._2()).stream().map(record -> record.toMap(Optional.ofNullable(condition).map(ConditionQueryRequest::getStringKeys).orElseGet(Collections::emptySet))).collect(Collectors.toList());
            return Tuple.of((Object)tuple._1(), mapResult);
        });
    }

    @Override
    public Either<String, Long> create(IEntityClass entityClass, Map<String, Object> body) {
        List<ValueUp> valueUps;
        OperationResult createResult;
        String transId = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY);
        SingleResponseRequestBuilder buildBuilder = this.entityServiceClient.build();
        if (transId != null) {
            buildBuilder.addHeader("transaction-id", transId);
        }
        if ((createResult = (OperationResult)buildBuilder.invoke((Object)EntityClassToGrpcConverter.toEntityUp(entityClass, null, valueUps = this.handlerValueService.handlerValue(entityClass, body, OperationType.CREATE))).toCompletableFuture().join()).getCode() == OperationResult.Code.OK) {
            if (createResult.getIdsList().size() < 1) {
                return Either.left((Object)"\u672a\u83b7\u5f97\u7ed3\u679c");
            }
            Long id = (Long)createResult.getIdsList().get(0);
            this.publisher.publishEvent((Object)this.buildCreatedEvent(entityClass, id, body));
            return Either.right((Object)id);
        }
        return Either.left((Object)createResult.getMessage());
    }

    @Override
    public Integer count(IEntityClass entityClass, ConditionQueryRequest condition) {
        OperationResult result;
        String transId = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY);
        SingleResponseRequestBuilder requestBuilder = this.entityServiceClient.selectByConditions();
        if (transId != null) {
            requestBuilder.addHeader("transaction-id", transId);
        }
        if ((result = (OperationResult)requestBuilder.invoke((Object)EntityClassToGrpcConverter.toSelectByCondition(entityClass, null, condition)).toCompletableFuture().join()).getCode() == OperationResult.Code.OK) {
            return result.getTotalRow();
        }
        return 0;
    }

    @Override
    public List<EntityClass> loadSonByCode(String bocode, String tenantId) {
        return this.loadSonByCode(bocode, tenantId, null);
    }

    @Override
    public List<EntityClass> loadSonByCode(String bocode, String tenantId, String version) {
        if (StringUtils.isEmpty((Object)tenantId)) {
            tenantId = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTID_KEY);
        }
        String appCode = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.APPCODE);
        if (version == null) {
            return this.metadataRepository.findSubEntitiesByCode(tenantId, appCode, bocode);
        }
        return this.metadataRepository.findSubEntitiesByCode(tenantId, appCode, bocode, version);
    }

    @Override
    public List<EntityClass> getEntityClasss() {
        return this.metadataRepository.findAllEntities();
    }

    private EntityDeleted buildDeleteEvent(IEntityClass entityClass, Long id) {
        String code = entityClass.code();
        Map<String, String> context = this.getContext();
        return new EntityDeleted(code, id, context);
    }

    private EntityCreated buildCreatedEvent(IEntityClass entityClass, Long id, Map<String, Object> data) {
        String code = entityClass.code();
        Map<String, String> context = this.getContext();
        return new EntityCreated(code, id, data, context);
    }

    private EntityUpdated buildUpdatedEvent(IEntityClass entityClass, Long id, Map<String, Object> data) {
        String code = entityClass.code();
        Map<String, String> context = this.getContext();
        return new EntityUpdated(code, id, data, context);
    }
}

