/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.impl;

import akka.japi.function.Function;
import akka.stream.IOResult;
import akka.stream.javadsl.FileIO;
import akka.stream.javadsl.Sink;
import akka.util.ByteString;
import com.xforceplus.ultraman.oqsengine.sdk.service.ExportSink;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileExportSink
implements ExportSink {
    private String contextPath = "download/file/%s";
    private String root = "/";
    private Logger logger = LoggerFactory.getLogger(LocalFileExportSink.class);

    public LocalFileExportSink(String root) {
        this.root = root;
    }

    @Override
    public Sink<ByteString, CompletionStage<Tuple2<IOResult, String>>> getSink(String token) {
        Path file = Paths.get(this.root, new String[0]).resolve(token + ".csv");
        return FileIO.toPath((Path)file).mapMaterializedValue((Function & Serializable)x -> x.thenApply(io -> Tuple.of((Object)io, (Object)token)));
    }

    @Override
    public String getDownloadUrl(String ... token) {
        return String.format(this.contextPath, token[0]);
    }

    @Override
    public InputStream getInputStream(String token) {
        try {
            return Files.newInputStream(Paths.get(this.root, new String[0]).resolve(token + ".csv"), new OpenOption[0]);
        }
        catch (IOException e) {
            this.logger.error("{}", (Throwable)e);
            return null;
        }
    }
}

