/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.impl;

import akka.Done;
import akka.japi.function.Function;
import akka.stream.IOResult;
import akka.stream.javadsl.Sink;
import akka.stream.javadsl.StreamConverters;
import akka.util.ByteString;
import com.xforceplus.tower.file.client.model.Policy;
import com.xforceplus.tower.storage.StorageFactory;
import com.xforceplus.tower.storage.model.UploadFileRequest;
import com.xforceplus.ultraman.oqsengine.sdk.service.ExportSink;
import com.xforceplus.xplat.galaxy.framework.context.ContextKeys;
import com.xforceplus.xplat.galaxy.framework.context.ContextService;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.io.InputStream;
import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import scala.util.Try;

public class StorageSink
implements ExportSink {
    private StorageFactory storageFactory;
    private ContextService contextService;
    private String appId;
    private String contextPath = "download/file/%s";

    public StorageSink(StorageFactory storageFactory, ContextService contextService, String appId) {
        this.storageFactory = storageFactory;
        this.contextService = contextService;
        this.appId = appId;
    }

    @Override
    public Sink<ByteString, CompletionStage<Tuple2<IOResult, String>>> getSink(String token) {
        Long telnetID = (Long)this.contextService.get((ContextService.ContextKey)ContextKeys.LongKeys.TENANT_ID);
        Long userID = (Long)this.contextService.get((ContextService.ContextKey)ContextKeys.LongKeys.ACCOUNT_ID);
        return StreamConverters.asInputStream((Duration)Duration.ofSeconds(50L)).mapMaterializedValue((Function & Serializable)x -> CompletableFuture.supplyAsync(() -> {
            Long fileId = this.upload(token, (InputStream)x, telnetID, userID);
            IOResult ioResult = new IOResult(0L, Try.apply(Done::getInstance));
            return Tuple.of((Object)ioResult, (Object)fileId.toString());
        }));
    }

    @Override
    public String getDownloadUrl(String ... token) {
        return String.format(this.contextPath, token[0]);
    }

    @Override
    public InputStream getInputStream(String token) {
        Long tenantId = (Long)this.contextService.get((ContextService.ContextKey)ContextKeys.LongKeys.TENANT_ID);
        Long userId = (Long)this.contextService.get((ContextService.ContextKey)ContextKeys.LongKeys.ACCOUNT_ID);
        return this.storageFactory.downloadInputStream(userId, tenantId, Long.valueOf(Long.parseLong(token)), null);
    }

    private Long upload(String name, InputStream inputStream, Long telnetID, Long userID) {
        UploadFileRequest uploadFileRequest = new UploadFileRequest();
        uploadFileRequest.setAppId(this.appId);
        uploadFileRequest.setExpires(Integer.valueOf(1));
        uploadFileRequest.setInputStream(inputStream);
        uploadFileRequest.setFileName(name);
        uploadFileRequest.setPolicy(Policy.PUBLIC_POLICY);
        uploadFileRequest.setTenantId(telnetID);
        uploadFileRequest.setUserId(userID);
        uploadFileRequest.setOverwrite(Boolean.valueOf(true));
        uploadFileRequest.setFilePath("/export/");
        return this.storageFactory.uploadByInputStream(uploadFileRequest);
    }
}

