/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.util;

import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionOp;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.Conditions;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.EntityItem;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.FieldCondition;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.FieldSort;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.SubEntityItem;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.SubFieldCondition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RequestBuilder {
    private Integer pageNo;
    private Integer pageSize;
    private ConditionBuilder conditionBuilder = new ConditionBuilder();
    private List<FieldSort> sort = new ArrayList<FieldSort>();
    private ItemBuilder itemBuilder = new ItemBuilder();

    public RequestBuilder field(String code, ConditionOp op, List<?> values) {
        List<String> strValues = values.stream().map(String::valueOf).collect(Collectors.toList());
        this.conditionBuilder.field(code, op, strValues);
        return this;
    }

    public RequestBuilder subField(String entityCode, String code, ConditionOp op, List<?> values) {
        List<String> strValues = values.stream().map(String::valueOf).collect(Collectors.toList());
        this.conditionBuilder.sub(entityCode).subField(code, op, strValues);
        return this;
    }

    public RequestBuilder field(String code, ConditionOp op, Object ... values) {
        List<String> strValues = Arrays.stream(values).map(String::valueOf).collect(Collectors.toList());
        this.conditionBuilder.field(code, op, strValues);
        return this;
    }

    public RequestBuilder subField(String entityCode, String code, ConditionOp op, Object ... values) {
        List<String> strValues = Arrays.stream(values).map(String::valueOf).collect(Collectors.toList());
        this.conditionBuilder.sub(entityCode).subField(code, op, strValues);
        return this;
    }

    public RequestBuilder item(List<String> fields) {
        String[] fieldArr = fields.toArray(new String[fields.size()]);
        this.itemBuilder.item(fieldArr);
        return this;
    }

    public RequestBuilder subItem(String entityCode, List<String> fields) {
        String[] fieldArr = fields.toArray(new String[fields.size()]);
        this.itemBuilder.sub(entityCode).subItem(fieldArr);
        return this;
    }

    public RequestBuilder item(String ... fields) {
        this.itemBuilder.item(fields);
        return this;
    }

    public RequestBuilder subItem(String entityCode, String ... fields) {
        this.itemBuilder.sub(entityCode).subItem(fields);
        return this;
    }

    public RequestBuilder pageNo(Integer pageNo) {
        this.pageNo = pageNo;
        return this;
    }

    public RequestBuilder pageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public RequestBuilder sort(String field, String order) {
        FieldSort fieldSort = new FieldSort();
        fieldSort.setField(field);
        fieldSort.setOrder(order);
        this.sort.add(fieldSort);
        return this;
    }

    public ConditionQueryRequest build() {
        ConditionQueryRequest request = new ConditionQueryRequest();
        request.setPageNo(this.pageNo);
        request.setPageSize(this.pageSize);
        request.setConditions(this.conditionBuilder.build());
        request.setSort(this.sort);
        request.setEntity(this.itemBuilder.build());
        return request;
    }

    private class ItemBuilder {
        private List<String> fields = new ArrayList<String>();
        private Map<String, SubEntityItem> entities = new HashMap<String, SubEntityItem>();
        private SubEntityItem subEntityItem;

        private ItemBuilder() {
        }

        public void item(String ... fields) {
            this.fields.addAll(Arrays.asList(fields));
        }

        public ItemBuilder sub(String code) {
            if (this.entities.containsKey(code)) {
                this.subEntityItem = this.entities.get(code);
            } else {
                this.subEntityItem = new SubEntityItem();
                this.subEntityItem.setCode(code);
                this.subEntityItem.setFields(new ArrayList<String>());
                this.entities.put(code, this.subEntityItem);
            }
            return this;
        }

        public void subItem(String ... fields) {
            this.subEntityItem.getFields().addAll(Arrays.asList(fields));
        }

        public EntityItem build() {
            EntityItem entityItem = new EntityItem();
            entityItem.setFields(this.fields);
            entityItem.setEntities(new ArrayList<SubEntityItem>(this.entities.values()));
            return entityItem;
        }
    }

    private class ConditionBuilder {
        private List<FieldCondition> fieldConditions = new ArrayList<FieldCondition>();
        private Map<String, SubFieldCondition> subFieldConditions = new HashMap<String, SubFieldCondition>();
        private SubFieldCondition subFieldCondition;

        private ConditionBuilder() {
        }

        public void field(String code, ConditionOp op, List<String> values) {
            FieldCondition fieldCondition = new FieldCondition();
            fieldCondition.setCode(code);
            fieldCondition.setOperation(op);
            fieldCondition.setValue(values);
            this.fieldConditions.add(fieldCondition);
        }

        public ConditionBuilder sub(String code) {
            if (this.subFieldConditions.containsKey(code)) {
                this.subFieldCondition = this.subFieldConditions.get(code);
            } else {
                this.subFieldCondition = new SubFieldCondition();
                this.subFieldCondition.setCode(code);
                this.subFieldCondition.setFields(new ArrayList<FieldCondition>());
                this.subFieldConditions.put(code, this.subFieldCondition);
            }
            return this;
        }

        public void subField(String code, ConditionOp op, List<String> values) {
            FieldCondition fieldCondition = new FieldCondition();
            fieldCondition.setCode(code);
            fieldCondition.setOperation(op);
            fieldCondition.setValue(values);
            this.subFieldCondition.getFields().add(fieldCondition);
        }

        public Conditions build() {
            Conditions conditions = new Conditions();
            conditions.setFields(this.fieldConditions);
            conditions.setEntities(new ArrayList<SubFieldCondition>(this.subFieldConditions.values()));
            return conditions;
        }
    }
}

