package com.xforceplus.ultraman.oqsengine.sdk.autoconfigurer;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

/**
 * class to determine global inited
 */
public class GlobalInited {

    private CountDownLatch moduleLatch;

    private Integer timeout;

    private Logger logger = LoggerFactory.getLogger(GlobalInited.class);

    public GlobalInited(@Value("${xplat.oqsengine.sdk.init-size:5}") Integer size
            , @Value("${xplat.oqsengine.sdk.init-timeout:10}") Integer timeout){
        this.moduleLatch = new CountDownLatch(size);
        this.timeout = timeout;
    }

    public void moduleSaved(){
        this.moduleLatch.countDown();
    }

    public void waiting(){
        try {
            logger.info("Waiting For Module at most {} sec", timeout);
            moduleLatch.await(timeout, TimeUnit.SECONDS);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}
