package com.xforceplus.ultraman.oqsengine.sdk.config.perm.page;

import com.alibaba.fastjson.JSON;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.Response;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.permission.RuleResult;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * page permission client
 */
public class PagePermissionClient {

    @Autowired
    private RestTemplate restTemplate;

    @Value("${xplat.oqsengine.sdk.permission.gateway}")
    private String permissionGateway;


    public RestTemplate getRestTemplate() {
        return restTemplate;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public String getPermissionGateway() {
        return permissionGateway;
    }

    public void setPermissionGateway(String permissionGateway) {
        this.permissionGateway = permissionGateway;
    }

    //get rules by roles and codes
    public List<RuleResult> getRules(List<Long> codes, String pageCode, String appId, String tenantCode, String pageTenant) {
        Response<List<Map>> result = new Response<>();
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        HttpEntity authorizeEntity = new HttpEntity(codes, headers);


//        UriB
//        UriBuilder builder = new UriBuilder().host(permissionGateway);

        UriComponentsBuilder host = UriComponentsBuilder.fromHttpUrl(permissionGateway).path(
                "/appId/{appId}/tenants/{tenantCode}/pages/{pageCode}/rules");

        if (StringUtils.isNoneEmpty(pageTenant)) {
            host = host.queryParam("pageTenant", pageTenant);
        }

        URI build = host.build(appId, tenantCode, pageCode);

        result = restTemplate.postForObject(build, authorizeEntity, Response.class);

        return result.getResult().stream()
                .map(x -> JSON.parseObject(JSON.toJSONString(x), RuleResult.class))
                .collect(Collectors.toList());
    }
}
