package com.xforceplus.ultraman.oqsengine.sdk.event.config;

import com.xforceplus.ultraman.config.event.ChangeList;

import java.util.concurrent.CountDownLatch;

/**
 * change event
 */
public class ConfigChangeEvent {

    private String type;
    private ChangeList changeList;
    private CountDownLatch latch;

    public ConfigChangeEvent(String type, ChangeList changeList) {
        this.type = type;
        this.changeList = changeList;
    }

    public ConfigChangeEvent(String type, ChangeList changeList, CountDownLatch latch) {
        this.type = type;
        this.changeList = changeList;
        this.latch = latch;
    }

    public CountDownLatch getLatch() {
        return latch;
    }

    public String getType() {
        return type;
    }

    public ChangeList getChangeList() {
        return changeList;
    }

    @Override
    public String toString() {
        return "ConfigChangeEvent{" +
                "type='" + type + '\'' +
                ", changeList=" + changeList +
                '}';
    }
}
