package com.xforceplus.ultraman.oqsengine.sdk.query.dsl;

import java.util.List;

/**
 * note the context is mutable！
 **/
public class ExpBuilder {

    ExpContext context;

    private ExpBuilder(ExpContext expContext){
        this.context = expContext;
    }

    public static ExpBuilder newBuilder(ExpContext context){
        return new ExpBuilder(context);
    }

    public ExpField field(String code){
        return ExpField.field(code);
    }

    public ExpCondition and(List<ExpNode> expNodes){
        return expNodes.isEmpty() ? ExpCondition.alwaysTrue() : ExpCondition.AND(expNodes);
    }

    public ExpCondition or(List<ExpNode> expNodes){
        return expNodes.isEmpty() ? ExpCondition.alwaysTrue() : ExpCondition.OR(expNodes);
    }

    public ExpValue literal(String value){
        return ExpValue.literal(value);
    }

    public ExpValue var(String value){
        return ExpValue.variable(value, context);
    }
}
