package com.xforceplus.ultraman.oqsengine.sdk.query.dsl;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

/**
 * relation expression
 */
public class ExpCondition extends ExpNode {


    int isAlwaysValue = -1;

    private ExpOperator operator;

    private List<ExpNode> expNodes = new LinkedList<>();

    ExpCondition(ExpOperator operator, List<ExpNode> nodes) {
        this.operator = operator;
        expNodes.addAll(nodes);
    }

    ExpCondition(boolean alwaysValue){
        this.isAlwaysValue = alwaysValue ? 1 : 0;
        this.operator = ExpOperator.DUMMY;
    }

    public ExpOperator getOperator() {
        return operator;
    }

    public List<ExpNode> getExpNodes() {
        return expNodes;
    }

    public static ExpCondition OR(List<ExpNode> nodes) {
        return new ExpCondition(ExpOperator.OR, nodes);
    }

    public static ExpCondition AND(List<ExpNode> nodes) {
        return new ExpCondition(ExpOperator.AND, nodes);
    }

    public static ExpCondition AND(ExpNode... nodes) {
        return new ExpCondition(ExpOperator.AND, Arrays.asList(nodes));
    }

    public static ExpCondition OR(ExpNode... nodes) {
        return new ExpCondition(ExpOperator.OR, Arrays.asList(nodes));
    }

    public static ExpCondition alwaysTrue(){
        return new ExpCondition(true);
    }

    public static ExpCondition alwaysFalse(){
        return new ExpCondition(false);
    }

    public boolean isAlwaysTrue() {
        return isAlwaysValue == 1;
    }

    public boolean isAlwaysFalse() {
        return isAlwaysValue == 0;
    }

    public static ExpCondition call(ExpOperator operator, List<ExpNode> nodes) {
        return new ExpCondition(operator, nodes);
    }

    public static ExpCondition call(ExpOperator operator, ExpNode... nodes) {
        return new ExpCondition(operator, Arrays.asList(nodes));
    }

    @Override
    public <R> R accept(ExpVisitor<R> visitor) {
        return visitor.visit(this);
    }
}
