package com.xforceplus.ultraman.oqsengine.sdk.query.dsl;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.reader.IEntityClassReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;

/**
 * Exp context
 */
public class ExpContext {

    private IEntityClassReader schema = null;

    private Map<String, Object> context = null;

    private Logger logger = LoggerFactory.getLogger(ExpContext.class);

    public ExpContext() {
    }

    /**
     * mutable ! caution
     *
     * @param context
     * @return
     */
    public ExpContext withContext(Map<String, Object> context) {
        this.context = new HashMap<>(context);
        return this;
    }

    public ExpContext withSchema(IEntityClass entityClass) {
        if (schema != null) {
            logger.warn("Changing Schema when has set, it maybe not properly");
        }

        if (entityClass == null) {
            logger.warn("Schema is empty");
            return this;
        }

        this.schema = new IEntityClassReader(entityClass);
        return this;
    }

    public IEntityClassReader getSchema() {
        return schema;
    }

    public Map<String, Object> getContext() {
        return context;
    }
}
