package com.xforceplus.ultraman.oqsengine.sdk.query.dsl;

import java.util.Objects;

/**
 * field
 */
public class ExpField extends ExpNode{

    private String name;

    private String alise;


    ExpField(String name){
        this.name = name;
    }

    public static ExpField field(String name){
        return new ExpField(name);
    }

    public ExpField as(String aliase){
        this.alise = aliase;
        return this;
    }

    public String getName() {
        return name;
    }

    @Override
    public <R> R accept(ExpVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ExpField expField = (ExpField) o;
        return Objects.equals(name, expField.name) &&
                Objects.equals(alise, expField.alise);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, alise);
    }
}
