package com.xforceplus.ultraman.oqsengine.sdk.query.dsl;

import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionOp;

import java.util.function.Predicate;
import java.util.stream.Stream;

import static com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpOperator.PreDef.*;
import static com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionOp.*;

/**
 * exp operator
 */
public enum ExpOperator {
    /**
     * or
     */
    OR(null, atLeast1),

    /**
     * and
     */
    AND(null, atLeast1),

    /**
     * equals
     */
    EQUALS(eq, binary),

    LIKE(like, binary),

    IN(in, atLeast1),

    NOT_IN(ni, atLeast1),

    GREATER_EQ_AND_LESS_EQ(ge_le, ternary),

    GREATER_EQ_AND_LESS_THAN(ge_lt, ternary),

    GREATER_THAN_AND_LESS_EQ(gt_le, ternary),

    GREATER_THAN_AND_LESS_THAN(gt_lt, ternary),

    GREATER_THAN(gt, binary),

    GREATER_EQUALS(ge, binary),

    LESS_THAN(lt, binary),

    LESS_EQUALS(le, binary),

    NOT_EQUALS(ne, binary),

    DUMMY(null, allowEmpty);

    ConditionOp op;

    Predicate<Integer> checkSize;

    ExpOperator(ConditionOp op, Predicate<Integer> checkSize) {
        this.op = op;
        this.checkSize = checkSize;
    }

    public String getShortName() {
        if (this == OR) return "or";
        if (this == AND) return "and";
        return op.name();
    }

    public static ExpOperator from(ConditionOp op) {
        return Stream.of(ExpOperator.values()).filter(x -> x.op == op)
                .findFirst().get();
    }

    /**
     * Predef 's constraits
     */
    public static class PreDef {

        public static final  Predicate<Integer> binary = s -> s == 2;

        public static final  Predicate<Integer> unary = s -> s == 1;

        public static final Predicate<Integer> ternary = s -> s == 3;

        public static final  Predicate<Integer> atLeast1 = s -> s > 0;

        public static final  Predicate<Integer> allowEmpty = s -> s >= 0;
    }
}
