package com.xforceplus.ultraman.oqsengine.sdk.query.dsl;

import com.google.common.collect.Sets;

import java.util.*;
import java.util.stream.Stream;

/**
 * exp sort
 */
public class ExpSort extends ExpNode {

    @Override
    public <R> R accept(ExpVisitor<R> visitor) {
        return visitor.visit(this);
    }

    /**
     * sort
     */
    public enum Sort {
        /**
         * ascend
         */
        ASCEND("asc", "ascend"),

        /**
         * descend
         */
        DESCEND("desc", "descend");


        Set<String> aliase;

        Sort(String... aliase) {
            this.aliase = Sets.newHashSet(aliase);
        }

        public static Sort from(String value) {
            Objects.requireNonNull(value, "Sort value cannot be null");
            Optional<Sort> first = Stream.of(Sort.values()).filter(x -> x.aliase.contains(value.toLowerCase())).findFirst();
            return first.orElseThrow(() -> new RuntimeException("Error input " + value));
        }
    }

    /**
     * field sort
     */
    public static class FieldSort {
        private String code;

        private Sort sort;

        public FieldSort(String code, Sort sort) {
            this.code = code;
            this.sort = sort;
        }

        public String getCode() {
            return code;
        }

        public Sort getSort() {
            return sort;
        }
    }

    public static ExpSort init() {
        return new ExpSort();
    }

    public ExpSort withSort(String fieldName, String sort) {
        sorts.add(new FieldSort(fieldName, Sort.from(sort)));
        return this;
    }

    private List<FieldSort> sorts = new LinkedList<>();

    public List<FieldSort> getSorts() {
        return sorts;
    }

    public ExpSort setSorts(List<FieldSort> sorts) {
        this.sorts.addAll(sorts);
        return this;
    }

    public ExpSort addSort(FieldSort fieldSort) {
        this.sorts.add(fieldSort);
        return this;
    }
}
