package com.xforceplus.ultraman.oqsengine.sdk.query.dsl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * literal value node
 * thread not safe
 */
public class ExpValue extends ExpNode {

    private String strValue;

    boolean isVar = false;

    private Logger logger = LoggerFactory.getLogger(ExpValue.class);

    ExpValue(String strValue) {
        this.strValue = strValue;
    }

    ExpValue(String strValue, boolean isVar) {
        this.strValue = strValue;
        this.isVar = isVar;
    }

    public static ExpValue literal(String strValue) {
        return new ExpValue(strValue);
    }

    public static ExpValue variable(String strValue, ExpContext context) {
        return new ExpValue(strValue, true);
    }

    public String getStrValue() {
        return strValue;
    }

    public void changeStrValue(String newValue) {
        if (strValue != null) {
            logger.warn("Change Value from {} -> {}", strValue, newValue);
        }
        strValue = newValue;
    }

    @Override
    public <R> R accept(ExpVisitor<R> visitor) {
        return visitor.visit(this);
    }
}
