package com.xforceplus.ultraman.oqsengine.sdk.query.dsl;

/**
 * ExpVisitor
 * @param <T> return value
 */
public interface ExpVisitor<T> {

    default T visitGeneral(ExpNode expNode) {
        if (expNode instanceof ExpField) {
            return visit((ExpField) expNode);
        } else if (expNode instanceof ExpCondition) {
            return visit((ExpCondition) expNode);
        } else if (expNode instanceof ExpValue) {
            return visit((ExpField) expNode);
        } else if (expNode instanceof ExpBi) {
            return visit((ExpBi) expNode);
        } else if (expNode instanceof ExpSort) {
            return visit((ExpSort) expNode);
        } else if (expNode instanceof ExpRange) {
            return visit((ExpRange) expNode);
        }

        return null;
    }

    T visit(ExpField field);

    T visit(ExpCondition rel);

    T visit(ExpValue value);

    T visit(ExpBi bi);

    T visit(ExpSort expSort);

    T visit(ExpRange range);
}
