package com.xforceplus.ultraman.oqsengine.sdk.query.transformer;

import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpContext;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpRel;

/**
 * Transformer and order
 */
public interface ExpTreeTransformer extends Comparable<ExpTreeTransformer>{

    ExpRel transform(ExpContext expContext, ExpRel expRel);

    int getOrder();

    @Override
    default int compareTo(ExpTreeTransformer o) {
        return Integer.compare(this.getOrder(), o.getOrder());
    }
}
