package com.xforceplus.ultraman.oqsengine.sdk.query.transformer;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.reader.IEntityClassReader;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.*;
import com.xforceplus.ultraman.oqsengine.sdk.service.OperationType;
import com.xforceplus.ultraman.oqsengine.sdk.service.operation.QuerySideFieldOperationHandler;
import com.xforceplus.ultraman.oqsengine.sdk.service.operation.TriFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;

import java.util.List;
import java.util.Optional;

/**
 * transformer to change a expRel to another when query
 */
public class QueryValueHandlerTransformer implements ExpTreeTransformer {

    private Logger logger = LoggerFactory.getLogger(QueryValueHandlerTransformer.class);

    final
    List<QuerySideFieldOperationHandler> querySideFieldOperationHandler;


    public QueryValueHandlerTransformer(List<QuerySideFieldOperationHandler> querySideFieldOperationHandler) {
        this.querySideFieldOperationHandler = querySideFieldOperationHandler;
    }

    @Override
    public ExpRel transform(ExpContext expContext, ExpRel expRel) {

        long transformStart = System.currentTimeMillis();
        //side-effect
        expRel.getFilters().forEach(expNode -> expNode.accept(new ContextAwareVisitor(expContext)));
        logger.info("Query Transform consume {}ms", System.currentTimeMillis() - transformStart);
        return expRel;
    }

    @Override
    public int getOrder() {
        //always do the last?
        //TODO check
        return Ordered.LOWEST_PRECEDENCE - 10000;
    }

    private Object pipeline(Object value, IEntityField field, OperationType phase) {
        try {
            return querySideFieldOperationHandler.stream()
                    .sorted()
                    .map(x -> (TriFunction) x)
                    .reduce(TriFunction::andThen)
                    .map(x -> x.apply(field, value, phase))
                    .orElse(value);

        } catch (Exception ex) {
            logger.error("{}", ex);
            return null;
        }
    }

    class ContextAwareVisitor implements ExpVisitor<Void> {

        private ExpContext context;

        public ContextAwareVisitor(ExpContext context) {
            this.context = context;
        }

        @Override
        public Void visit(ExpField field) {
            return null;
        }

        @Override
        public Void visit(ExpCondition rel) {
            IEntityClassReader schema = context.getSchema();
            if (rel.getOperator() != ExpOperator.AND && rel.getOperator() != ExpOperator.OR) {
                Optional<ExpNode> firstField = rel.getExpNodes().stream().filter(x -> x instanceof ExpField).findFirst();
                if (firstField.isPresent()) {
                    ExpField field = (ExpField) firstField.get();
                    Optional<? extends IEntityField> schemaField = schema.column(field.getName());
                    if (schemaField.isPresent()) {
                        rel.getExpNodes()
                                .stream().filter(x -> x instanceof ExpValue)
                                .forEach(x -> {
                                    Object pipeline = pipeline(((ExpValue) x).getStrValue(), schemaField.get(), OperationType.QUERY);
                                    if (pipeline != null) {
                                        ((ExpValue) x).changeStrValue(pipeline.toString());
                                    }
                                });
                    }
                }
            } else {
                rel.getExpNodes().forEach(x -> x.accept(this));
            }
            return null;
        }

        @Override
        public Void visit(ExpValue value) {
            return null;
        }

        @Override
        public Void visit(ExpBi bi) {
            return null;
        }

        @Override
        public Void visit(ExpSort expSort) {
            return null;
        }

        @Override
        public Void visit(ExpRange range) {
            return null;
        }
    }
}
