package com.xforceplus.ultraman.oqsengine.sdk.query.transformer.optimizer;

import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.*;
import com.xforceplus.ultraman.oqsengine.sdk.query.transformer.optimizer.utils.ExpTreeToRel;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.rel2sql.RelToSqlConverter;
import org.apache.calcite.rel.rules.PruneEmptyRules;
import org.apache.calcite.rel.rules.ReduceExpressionsRule;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.dialect.CalciteSqlDialect;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.stream.Collectors;

/**
 * optimizer
 */
public class CalciteConditionOptimizer implements ExpConditionOptimizer {

    private Logger logger = LoggerFactory.getLogger(CalciteConditionOptimizer.class);

    @Autowired
    private List<RelOptRule> rules;

    @Autowired
    private FrameworkConfig config;


    class OrCheckVisitor implements ExpVisitor {

        boolean hasOr = false;

        @Override
        public Object visit(ExpField field) {
            return null;
        }

        @Override
        public Object visit(ExpCondition rel) {
            if (rel.getOperator() == ExpOperator.OR) {
                hasOr = true;
            } else {
                rel.getExpNodes().stream().map(x -> x.accept(this)).collect(Collectors.toList());
            }

            return null;
        }

        @Override
        public Object visit(ExpValue value) {
            return null;
        }

        @Override
        public Object visit(ExpBi bi) {
            return null;
        }

        @Override
        public Object visit(ExpSort expSort) {
            return null;
        }

        @Override
        public Object visit(ExpRange range) {
            return null;
        }

        public boolean isHasOr() {
            return hasOr;
        }
    }

    @Override
    public ExpRel transform(ExpContext expContext, ExpRel expRel) {

        OrCheckVisitor orCheckVisitor = new OrCheckVisitor();
        expRel.accept(orCheckVisitor);

        if (orCheckVisitor.hasOr) {

            long optimizer = System.currentTimeMillis();

            RelNode opTree = ExpTreeToRel.toRelTree(expContext.getSchema().getEntityClass(), expRel, config);

            long transToTree = System.currentTimeMillis();
            logger.info("Trans consume {}ms", transToTree - optimizer);

            HepProgramBuilder hepProgramBuilder = HepProgram.builder()
                    .addRuleInstance(PruneEmptyRules.FILTER_INSTANCE)
                    .addRuleInstance(ReduceExpressionsRule.FILTER_INSTANCE);

            rules.forEach(hepProgramBuilder::addRuleInstance);
            HepProgram program = hepProgramBuilder.build();

            HepPlanner hepPlanner = new HepPlanner(program);
            hepPlanner.setRoot(opTree);
            RelNode optimized = hepPlanner.findBestExp();

            logger.info("Real Optimizer consume {}ms", System.currentTimeMillis() - transToTree);


            SqlNode sqlNodeOrigin = new RelToSqlConverter(CalciteSqlDialect.DEFAULT).visitChild(0, opTree).asStatement();
            SqlNode sqlNode = new RelToSqlConverter(CalciteSqlDialect.DEFAULT).visitChild(0, optimized).asStatement();


            logger.debug("Origin is:" + Util.toLinux(sqlNodeOrigin.toSqlString(CalciteSqlDialect.DEFAULT).getSql()).replaceAll("\n", " "));
            logger.debug("Current is:" + Util.toLinux(sqlNode.toSqlString(CalciteSqlDialect.DEFAULT).getSql()).replaceAll("\n", " "));
            //relNode t0 ExpRel
            List<RelDataTypeField> fieldList = optimized.getRowType().getFieldList();

            ExpNode query = ExpTreeToRel.toExpTree(optimized, fieldList);

            ExpQuery newQuery = new ExpQuery();

            newQuery.project(expRel.getProjects())
                    .filters(query)
                    .sort(expRel.getSorts());
            if (expRel.getRange() != null) {
                newQuery.range(expRel.getRange().getIndex(), expRel.getRange().getSize());
            }

            logger.info("Optimizer consume {}ms", System.currentTimeMillis() - optimizer);
            return newQuery;
        } else {
            return expRel;
        }
    }

    @Override
    public int getOrder() {
        return 0;
    }
}
