package com.xforceplus.ultraman.oqsengine.sdk.query.transformer.optimizer;

import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.*;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import static com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpOperator.AND;
import static com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpOperator.OR;

/**
 * remove empty condition
 */
public class EmptyConditionRemover implements ExpConditionOptimizer {
    @Override
    public ExpRel transform(ExpContext expContext, ExpRel expRel) {

        /**
         * should a query
         */
        if (expRel instanceof ExpQuery) {
            ExpQuery newQuery = new ExpQuery();
            newQuery.project(expRel.getProjects());
            newQuery.sort(expRel.getSorts());
            //TODO this should be the or
            newQuery.filters(optimizer(OR, expRel.getFilters()));
            if (expRel.getRange() != null) {
                newQuery.range(expRel.getRange().getIndex(), expRel.getRange().getSize());
            }

            return newQuery;
        }

        return expRel;
    }

    /**
     * filters is or linked
     *
     * @param oldFilters
     * @return
     */
    private List<ExpNode> optimizer(ExpOperator expOperator, List<ExpNode> oldFilters) {

        if (expOperator == OR) {
            //1 or any == 1
            boolean hasAlwaysTrue = oldFilters.stream().anyMatch(x -> {
                if (x instanceof ExpCondition) {
                    return ((ExpCondition) x).isAlwaysTrue();
                }
                return false;
            });

            if (hasAlwaysTrue) {
                return Collections.singletonList(ExpCondition.alwaysTrue());
            }

            /**
             * remove collections
             */
            // 1 and any == any
            List<ExpNode> nonAlways = oldFilters.stream().filter(x -> {
                if (x instanceof ExpCondition) {
                    return !((ExpCondition) x).isAlwaysFalse();
                }
                //should condition
                return false;
            }).collect(Collectors.toList());

            return nonAlways.stream().map(x -> {
                //remove
                HasEmptyNode hasEmptyNode = new HasEmptyNode();
                x.accept(hasEmptyNode);
                if (hasEmptyNode.hasEmpty) {
                    return newCondition(x);
                } else {
                    return x;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
        } else if (expOperator == AND) {

            boolean hasAlwaysFalse = oldFilters.stream().anyMatch(x -> {
                if (x instanceof ExpCondition) {
                    return ((ExpCondition) x).isAlwaysFalse();
                }
                return false;
            });

            if (hasAlwaysFalse) {
                return Collections.singletonList(ExpCondition.alwaysFalse());
            }

            /**
             * remove collections
             */
            // 1 and any == any
            List<ExpNode> nonAlways = oldFilters.stream().filter(x -> {
                if (x instanceof ExpCondition) {
                    return !((ExpCondition) x).isAlwaysTrue();
                }
                //should condition
                return false;
            }).collect(Collectors.toList());

            return nonAlways.stream().map(x -> {
                //remove
                HasEmptyNode hasEmptyNode = new HasEmptyNode();
                x.accept(hasEmptyNode);
                if (hasEmptyNode.hasEmpty) {
                    return newCondition(x);
                } else {
                    return x;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());

        } else {
            return oldFilters;
        }
    }

    /**
     * expNode is a condition and not always true or false
     *
     * @param expNode
     */
    private ExpNode newCondition(ExpNode expNode) {
        ExpCondition cond = (ExpCondition) expNode;

        //TODO
        List<ExpNode> optimizedConds = optimizer(cond.getOperator(), cond.getExpNodes());

        if (optimizedConds.isEmpty()) {
            return null;
        }

        if (optimizedConds.size() == 1) {

            if (((ExpCondition) optimizedConds.get(0)).isAlwaysTrue()) {
                return ExpCondition.alwaysTrue();
            } else if (((ExpCondition) optimizedConds.get(0)).isAlwaysFalse()) {
                return ExpCondition.alwaysFalse();
            }
        }

        //optimizer or
        ExpCondition newCond = ExpCondition.call(cond.getOperator(), optimizedConds);
        return newCond;
    }

    /**
     * empty checker
     */
    class HasEmptyNode implements ExpVisitor {

        boolean hasEmpty = false;

        @Override
        public Object visit(ExpField field) {
            return null;
        }

        /**
         * only check and and or clause
         *
         * @param rel
         * @return
         */
        @Override
        public Object visit(ExpCondition rel) {
            if (rel.getOperator() == AND || rel.getOperator() == OR) {
                if (rel.getExpNodes().isEmpty()) {
                    hasEmpty = true;
                } else {
                    rel.getExpNodes().forEach(x -> x.accept(this));
                }
            } else if (rel.getOperator() == ExpOperator.DUMMY) {
                hasEmpty = true;
            }
            return null;
        }

        @Override
        public Object visit(ExpValue value) {
            return null;
        }

        @Override
        public Object visit(ExpBi bi) {
            return null;
        }

        @Override
        public Object visit(ExpSort expSort) {
            return null;
        }

        @Override
        public Object visit(ExpRange range) {
            return null;
        }
    }

    @Override
    public int getOrder() {
        return 0;
    }
}
