package com.xforceplus.ultraman.oqsengine.sdk.query.transformer.optimizer;

import com.google.common.collect.ImmutableMap;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.sdk.config.AuthSearcherConfig;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.MetadataRepository;
import org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * TODO using
 * IEntityClassSchema
 */
public class IEntityClassSchema extends AbstractSchema {

    private Logger logger = LoggerFactory.getLogger(IEntityClassSchema.class);

    private MetadataRepository repository;

    private AuthSearcherConfig config;

    public IEntityClassSchema(MetadataRepository repository, AuthSearcherConfig config) {
        this.repository = repository;
        this.config = config;
    }

    @Override
    protected Map<String, Table> getTableMap() {
        return new LazySchemaMap<>(code -> {
            return repository.loadByCode(config.getTenant(), config.getAppId(), code)
                    .map(IEntityClassTable::new)
                    .orElseThrow(() -> new RuntimeException("No Related EntityClass Name " + code));
        });
    }

    private static class IEntityClassTable
            extends AbstractQueryableTable
            implements Table {

        private Logger logger = LoggerFactory.getLogger(IEntityClassTable.class);

        IEntityClass iEntityClass;

        IEntityClassTable(IEntityClass entityClass) {
            super(Object[].class);
            this.iEntityClass = entityClass;
        }

        /**
         * return fields
         *
         * @param relDataTypeFactory
         * @return
         */
        @Override
        public RelDataType getRowType(RelDataTypeFactory relDataTypeFactory) {

            IEntityClass entity = iEntityClass;
            Collection<IEntityField> fields = entity.fields();
            //TODO convert Types
            long createStart = System.currentTimeMillis();
            final List<Map.Entry<String, RelDataType>> names =
                    fields.stream()
                            .map(x -> Pair.of(x.name(), fieldTypeToRelDataType(relDataTypeFactory, x.type())))
                            .collect(Collectors.toList());
            long createEnd = System.currentTimeMillis();

            logger.info("Type Create Time {}",  createEnd - createStart);
            RelDataType structType = relDataTypeFactory.createStructType(names);

            logger.info("Real Type Create Time {}", System.currentTimeMillis() - createEnd);

            return structType;
        }

        private RelDataType fieldTypeToRelDataType(RelDataTypeFactory relDataTypeFactory, FieldType fieldType){
            return relDataTypeFactory.createJavaType(fieldType.getJavaType());
        }


        @Override
        public Statistic getStatistic() {
            return Statistics.UNKNOWN;
        }

        @Override
        public <T> Queryable<T> asQueryable(QueryProvider queryProvider,
                                            SchemaPlus schema, String tableName) {
            return null;
        }
    }
}
