package com.xforceplus.ultraman.oqsengine.sdk.query.validate;


import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.*;
import io.vavr.control.Either;

/**
 *
 */
public class ExpRangeValidator implements ExpTreeValidator {


    private boolean isRangeStrict;

    public ExpRangeValidator(boolean isRangeStrict) {
        this.isRangeStrict = isRangeStrict;
    }

    @Override
    public Either<String, Boolean> validate(ExpContext expContext, ExpRel exp) {
        ValidationVisitor validationVisitor = new ValidationVisitor(isRangeStrict);
        exp.accept(validationVisitor);
        return validationVisitor.isInValidate() ? Either.left(validationVisitor.getMessage()) : Either.right(true);
    }

    class ValidationVisitor implements ExpVisitor<Void> {

        private boolean isRangeStrict;

        private boolean inValidate = false;

        private String message = "";

        public ValidationVisitor(boolean isRangeStrict) {
            this.isRangeStrict = isRangeStrict;
        }

        public boolean isInValidate() {
            return inValidate;
        }

        public String getMessage() {
            return message;
        }

        @Override
        public Void visit(ExpField field) {
            return null;
        }

        @Override
        public Void visit(ExpCondition rel) {
            return null;
        }

        @Override
        public Void visit(ExpValue value) {
            return null;
        }

        @Override
        public Void visit(ExpBi bi) {
            return null;
        }

        @Override
        public Void visit(ExpSort expSort) {
            return null;
        }

        @Override
        public Void visit(ExpRange range) {
            if (isRangeStrict) {
                boolean noRange = (range.getSize() == null || range.getIndex() == null);
                if (noRange) {
                    inValidate = true;
                    message = ("[STRICT-MODE]: RangeSearch Without Range");
                }
            }
            return null;
        }
    }
}
