package com.xforceplus.ultraman.oqsengine.sdk.query.validate;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.reader.IEntityClassReader;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.*;
import com.xforceplus.ultraman.oqsengine.sdk.service.OperationType;
import com.xforceplus.ultraman.oqsengine.sdk.service.operation.validator.FieldValidator;
import io.vavr.control.Either;
import io.vavr.control.Validation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * validator
 */
public class ExpTreeValidatorImpl implements ExpTreeValidator {

    @Autowired
    private final List<FieldValidator<Object>> fieldValidators;

    public ExpTreeValidatorImpl(List<FieldValidator<Object>> fieldValidators) {
        this.fieldValidators = fieldValidators;
    }

    //private List<Validation<String, Object>> validate(IEntityField field, Object obj, OperationType phase) {
    @Override
    public Either<String, Boolean> validate(ExpContext expContext, ExpRel exp) {
        ValidationVisitor visitor = new ValidationVisitor(expContext);
        exp.accept(visitor);

        List<Validation<String, Object>> validationList = visitor.getValidationList();

        String errorMessage = validationList.stream()
                .map(Validation::getError)
                .collect(Collectors.joining(","));

        if (!StringUtils.isEmpty(errorMessage)) {
            return Either.left(errorMessage);
        } else {
            return Either.right(true);
        }
    }

    List<Validation<String, Object>> validate(IEntityField field, Object obj, OperationType phase) {
        return fieldValidators.stream()
                .map(x -> x.validate(field, obj, phase))
                .filter(Validation::isInvalid)
                .collect(Collectors.toList());
    }

    class ValidationVisitor implements ExpVisitor<Void> {

        private ExpContext context;

        private List<Validation<String, Object>> validationList = new LinkedList<>();

        public ValidationVisitor(ExpContext context) {
            this.context = context;
        }

        public List<Validation<String, Object>> getValidationList() {
            return validationList;
        }

        @Override
        public Void visit(ExpField field) {
            return null;
        }

        @Override
        public Void visit(ExpCondition rel) {
            IEntityClassReader schema = context.getSchema();
            if (rel.getOperator() != ExpOperator.AND && rel.getOperator() != ExpOperator.OR) {
                Optional<ExpNode> firstField = rel.getExpNodes().stream().filter(x -> x instanceof ExpField).findFirst();
                if (firstField.isPresent()) {
                    ExpField field = (ExpField) firstField.get();
                    Optional<? extends IEntityField> schemaField = schema.column(field.getName());
                    schemaField.ifPresent(entityField -> rel.getExpNodes()
                            .stream().filter(x -> x instanceof ExpValue)
                            .forEach(x -> {
                                validationList.addAll(validate(entityField, ((ExpValue) x).getStrValue(), OperationType.QUERY));
                            }));
                }
            } else {
                rel.getExpNodes().forEach(x -> x.accept(this));
            }
            return null;
        }

        @Override
        public Void visit(ExpValue value) {
            return null;
        }

        @Override
        public Void visit(ExpBi bi) {
            return null;
        }

        @Override
        public Void visit(ExpSort expSort) {
            return null;
        }

        @Override
        public Void visit(ExpRange range) {
            return null;
        }
    }
}
