package com.xforceplus.ultraman.oqsengine.sdk.service.impl;

import akka.grpc.javadsl.SingleResponseRequestBuilder;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.Record;
import com.xforceplus.ultraman.oqsengine.sdk.EntityServiceClient;
import com.xforceplus.ultraman.oqsengine.sdk.OperationResult;
import com.xforceplus.ultraman.oqsengine.sdk.SelectByTree;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpContext;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpRel;
import com.xforceplus.ultraman.oqsengine.sdk.query.transformer.ExpTreeTransformer;
import com.xforceplus.ultraman.oqsengine.sdk.query.transformer.QueryValueHandlerTransformer;
import com.xforceplus.ultraman.oqsengine.sdk.query.utils.RelTreeHelper;
import com.xforceplus.ultraman.oqsengine.sdk.query.validate.ExpTreeValidator;
import com.xforceplus.ultraman.oqsengine.sdk.service.ExecutionService;
import com.xforceplus.ultraman.oqsengine.sdk.service.HandleResultValueService;
import com.xforceplus.ultraman.oqsengine.sdk.vo.DataCollection;
import com.xforceplus.xplat.galaxy.framework.context.ContextService;
import io.vavr.control.Either;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;

import static com.xforceplus.xplat.galaxy.framework.context.ContextKeys.StringKeys.TRANSACTION_KEY;

/**
 * ExecutionService
 */
public class ExecutionServiceImpl implements ExecutionService {

    @Autowired
    private List<ExpTreeTransformer> transformers;

    @Autowired
    private HandleResultValueService handleResultValueService;

    @Autowired
    private List<ExpTreeValidator> validators;

    @Autowired
    private ContextService contextService;

    private Logger logger = LoggerFactory.getLogger(ExecutorService.class);

    @Autowired
    private EntityServiceClient entityServiceClient;

    @Override
    public Either<String, DataCollection<Record>> query(ExpContext context, ExpRel rel) {
        /**
         * new tree
         */

        long queryTotalStart = System.currentTimeMillis();
        List<ExpTreeTransformer> orderedTransformers = transformers
                .stream().sorted()
                .collect(Collectors.toList());
        long transformStart = System.currentTimeMillis();
        ExpRel temp = rel;
        for (ExpTreeTransformer treeTransformer : orderedTransformers){
            temp = treeTransformer.transform(context, temp);
        }
        logger.info("Transform consume {}ms", System.currentTimeMillis() - transformStart);

        ExpRel newTree = temp;

        long validatorStart = System.currentTimeMillis();
        /**
         * validator
         */
        validators.forEach(x -> {
            x.validate(context, newTree).getOrElseThrow((Function<String, RuntimeException>) RuntimeException::new);
        });

        logger.info("Validator consume {}ms", System.currentTimeMillis() - validatorStart);

        String transId = contextService.get(TRANSACTION_KEY);
        SingleResponseRequestBuilder<SelectByTree, OperationResult> requestBuilder = entityServiceClient.selectByTreeFilter();

        if (transId != null) {
            logger.info("findRecordsByCondition with Transaction id:{} ", transId);
            requestBuilder = requestBuilder.addHeader("transaction-id", transId);
        }

        /**
         * to Filters
         */
        SelectByTree selectByTree = RelTreeHelper.relToTree(context.getSchema().getEntityClass(), newTree, context);

        long queryStart = System.currentTimeMillis();
        /**
         * condition
         * TODO
         */
        OperationResult result = requestBuilder.invoke(selectByTree).toCompletableFuture().join();
        logger.info("Query consume {}ms", System.currentTimeMillis() - queryStart);
        logger.info("Query total consume {}ms", System.currentTimeMillis() - queryTotalStart);

        if (result.getCode() == OperationResult.Code.OK) {
            List<Record> repList = result.getQueryResultList()
                    .stream()
                    .map(x -> {
                        return handleResultValueService.toRecord(context.getSchema().getEntityClass(), x);
                    }).collect(Collectors.toList());
            DataCollection<Record> dataCollection = new DataCollection<>(result.getTotalRow(), repList);
            return Either.right(dataCollection);
        } else {
            return Either.left(result.getMessage());
        }
    }
}
