package com.xforceplus.ultraman.oqsengine.sdk.service.impl;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.xforceplus.ultraman.oqsengine.sdk.config.perm.page.PagePermissionClient;
import com.xforceplus.ultraman.oqsengine.sdk.service.PagePermissionService;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.permission.RuleResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

/**
 * page permission service impl
 */
public class PagePermissionServiceImpl implements PagePermissionService {

    @Autowired
    private PagePermissionClient client;

    private Logger logger = LoggerFactory.getLogger(PagePermissionService.class);

    LoadingCache<PermissionKey, List<RuleResult>> cache;

    public PagePermissionServiceImpl() {
        cache = Caffeine.newBuilder()
                .maximumSize(1000)
                .refreshAfterWrite(30, TimeUnit.SECONDS)
                .build(key -> {
                    logger.info("[Permission]Get From Real backend with {}", key);
                    //getRules(List<Long> codes, String pageCode, String appId, String tenantCode, String pageTenant)
                    return client.getRules(key.getRoleIds(), key.getPageCode(), key.getAppId(), key.getTenantCode(), key.getPageTenant());
                });
    }

    static class PermissionKey {

        Long tenantId;

        Long page;

        String tenantCode;

        String pageCode;

        String appId;

        String pageTenant;

        List<Long> roleIds;

        public Long getTenantId() {
            return tenantId;
        }

        public void setTenantId(Long tenantId) {
            this.tenantId = tenantId;
        }

        public Long getPage() {
            return page;
        }

        public void setPage(Long page) {
            this.page = page;
        }

        public List<Long> getRoleIds() {
            return roleIds;
        }

        public void setRoleIds(List<Long> roleIds) {
            this.roleIds = roleIds;
        }

        public String getTenantCode() {
            return tenantCode;
        }

        public String getPageCode() {
            return pageCode;
        }

        public void setTenantCode(String tenantCode) {
            this.tenantCode = tenantCode;
        }

        public void setPageCode(String pageCode) {
            this.pageCode = pageCode;
        }

        public String getAppId() {
            return appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public String getPageTenant() {
            return pageTenant;
        }

        public void setPageTenant(String pageTenant) {
            this.pageTenant = pageTenant;
        }

        @Override
        public String toString() {
            return "PermissionKey{" +
                    "tenantId=" + tenantId +
                    ", page=" + page +
                    ", tenantCode='" + tenantCode + '\'' +
                    ", pageCode='" + pageCode + '\'' +
                    ", appId='" + appId + '\'' +
                    ", pageTenant='" + pageTenant + '\'' +
                    ", roleIds=" + roleIds +
                    '}';
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            PermissionKey that = (PermissionKey) o;
            return Objects.equals(tenantId, that.tenantId) &&
                    Objects.equals(page, that.page) &&
                    Objects.equals(tenantCode, that.tenantCode) &&
                    Objects.equals(pageCode, that.pageCode) &&
                    Objects.equals(appId, that.appId) &&
                    Objects.equals(pageTenant, that.pageTenant) &&
                    Objects.equals(roleIds, that.roleIds);
        }

        @Override
        public int hashCode() {
            return Objects.hash(tenantId, page, tenantCode, pageCode, appId, pageTenant, roleIds);
        }
    }

    @Override
    public List<RuleResult> getRuleResults(Long tenantId
            , Long page
            , String appId
            , String pageCode, String tenantCode
            , String pageTenant
            , List<Long> roleIds) {

        PermissionKey key = new PermissionKey();
        key.setPage(page);
        key.setTenantId(tenantId);
        key.setRoleIds(roleIds);
        key.setAppId(appId);
        key.setPageCode(pageCode);
        key.setTenantCode(tenantCode);
        key.setPageTenant(pageTenant);

        return cache.get(key);
    }
}
