package com.xforceplus.ultraman.oqsengine.sdk.util;

import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Condition;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.ConditionOperator;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.ColumnField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import com.xforceplus.ultraman.oqsengine.pojo.reader.IEntityClassReader;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionOp;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.FieldCondition;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.SubFieldCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

/**
 * query transformer
 */
public class QueryTransformer {

    private Logger logger = LoggerFactory.getLogger(QueryTransformer.class);

    public Conditions toConditions(IEntityClass mainClass
            , IEntityClassReader reader
            , ConditionQueryRequest request) {
        //conditions != null
        com.xforceplus.ultraman.oqsengine.sdk.vo.dto.Conditions conditions = request.getConditions();

        List<FieldCondition> fields = conditions.getFields();
        List<SubFieldCondition> entities = conditions.getEntities();

        /**
         * conditions list from main
         */
        List<Conditions> conditionsMain = fields.stream().map(x -> {
            String code = x.getCode();
            return toOneConditions(reader.column(code), x, mainClass);
        }).collect(Collectors.toList());

        List<Conditions> conditionsSubs = entities.stream().flatMap(x -> {
            return x.getFields().stream().map(y -> {
                return toOneConditions(reader.column(x.getCode() + "." + y.getCode()), y, mainClass);
            });
        }).collect(Collectors.toList());

        List<Conditions> conditionsAll = new ArrayList<>(conditionsMain);
        conditionsAll.addAll(conditionsSubs);

        return conditionsAll.stream().reduce(Conditions
                .buildEmtpyConditions(), (a, b) -> a.addAnd(b, false));
    }

    private boolean isRelatedField(ColumnField columnField, IEntityClass mainClass) {
        IEntityClass entityClass = columnField.originEntityClass();

        if (mainClass.extendEntityClass() != null) {
            return mainClass.id() != entityClass.id() && mainClass.extendEntityClass().id() != entityClass.id();
        } else {
            return entityClass.id() != mainClass.id();
        }
    }

    private List<IValue> toTypedValue(IEntityField entityField, String value) {
        return entityField.type().toTypedValue(entityField, value).map(Collections::singletonList).orElseGet(Collections::emptyList);
    }

    private Conditions toOneConditions(Optional<ColumnField> fieldOp, FieldCondition fieldCondition, IEntityClass mainClass) {

        Conditions conditions = null;

        if (fieldOp.isPresent()) {
            ConditionOp op = fieldCondition.getOperation();

            ColumnField columnField = fieldOp.get();
            IEntityField originField = columnField;

            //in order
            List<String> nonNullValueList = fieldCondition
                    .getValue()
                    .stream()
                    .filter(Objects::nonNull)
                    .collect(Collectors.toList());

            //return if field with invalid
            if (nonNullValueList.isEmpty()) {
//                conditions = Conditions.buildEmtpyConditions();
//                return conditions;
                throw new RuntimeException("Field " + columnField + " Value is Missing");
            }

            switch (op) {
                case eq:
                    conditions = new Conditions(new Condition(
                            isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null
                            , originField
                            , ConditionOperator.EQUALS
                            , toTypedValue(fieldOp.get()
                            , nonNullValueList.get(0)).toArray(new IValue[]{})));
                    break;
                case ne:
                    conditions = new Conditions(new Condition(
                            isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null
                            , originField
                            , ConditionOperator.NOT_EQUALS
                            , toTypedValue(fieldOp.get()
                            , nonNullValueList.get(0)).toArray(new IValue[]{})));
                    break;
                case ge:
                    conditions = new Conditions(new Condition(
                            isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null
                            , originField
                            , ConditionOperator.GREATER_THAN_EQUALS
                            , toTypedValue(fieldOp.get()
                            , nonNullValueList.get(0)).toArray(new IValue[]{})));
                    break;
                case gt:
                    conditions = new Conditions(new Condition(
                            isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null
                            , originField
                            , ConditionOperator.GREATER_THAN
                            , toTypedValue(fieldOp.get()
                            , nonNullValueList.get(0)).toArray(new IValue[]{})));
                    break;
                case ge_le:
                    if (nonNullValueList.size() > 1) {
                        Condition left = new Condition(
                                isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null
                                , originField
                                , ConditionOperator.GREATER_THAN_EQUALS
                                , toTypedValue(fieldOp.get()
                                , nonNullValueList.get(0)).toArray(new IValue[]{}));

                        Condition right = new Condition(
                                isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null
                                , originField
                                , ConditionOperator.LESS_THAN_EQUALS
                                , toTypedValue(fieldOp.get()
                                , nonNullValueList.get(1)).toArray(new IValue[]{}));

                        conditions = new Conditions(left).addAnd(right);

                    } else {
                        logger.warn("required value more then 2, fallback to ge");
                        conditions = new Conditions(new Condition(
                                isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null
                                , originField
                                , ConditionOperator.GREATER_THAN_EQUALS
                                , toTypedValue(fieldOp.get()
                                , nonNullValueList.get(0)).toArray(new IValue[]{})));
                    }
                    break;
                case gt_le:
                    if (nonNullValueList.size() > 1) {
                        Condition left = new Condition(
                                isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null
                                , originField
                                , ConditionOperator.GREATER_THAN
                                , toTypedValue(fieldOp.get()
                                , nonNullValueList.get(0)).toArray(new IValue[]{}));

                        Condition right = new Condition(
                                isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null
                                , originField
                                , ConditionOperator.LESS_THAN_EQUALS
                                , toTypedValue(fieldOp.get()
                                , nonNullValueList.get(1)).toArray(new IValue[]{}));


                        conditions = new Conditions(left).addAnd(right);

                    } else {
                        logger.warn("required value more then 2, fallback to gt");
                        conditions = new Conditions(new Condition(
                                isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null
                                , originField
                                , ConditionOperator.GREATER_THAN
                                , toTypedValue(fieldOp.get()
                                , nonNullValueList.get(0)).toArray(new IValue[]{})));
                    }
                    break;
                case ge_lt:
                    if (nonNullValueList.size() > 1) {
                        Condition left = new Condition(
                                isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null
                                , originField
                                , ConditionOperator.GREATER_THAN_EQUALS
                                , toTypedValue(fieldOp.get()
                                , nonNullValueList.get(0)).toArray(new IValue[]{}));

                        Condition right = new Condition(
                                isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null
                                , originField
                                , ConditionOperator.LESS_THAN
                                , toTypedValue(fieldOp.get()
                                , nonNullValueList.get(1)).toArray(new IValue[]{}));


                        conditions = new Conditions(left).addAnd(right);

                    } else {
                        logger.warn("required value more then 2, fallback to ge");
                        conditions = new Conditions(new Condition(
                                isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null
                                , originField
                                , ConditionOperator.GREATER_THAN_EQUALS
                                , toTypedValue(fieldOp.get()
                                , nonNullValueList.get(0)).toArray(new IValue[]{})));
                    }
                    break;
                case gt_lt:
                    if (nonNullValueList.size() > 1) {
                        Condition left = new Condition(
                                isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null
                                , originField
                                , ConditionOperator.GREATER_THAN
                                , toTypedValue(fieldOp.get()
                                , nonNullValueList.get(0)).toArray(new IValue[]{}));

                        Condition right = new Condition(
                                isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null
                                , originField
                                , ConditionOperator.LESS_THAN
                                , toTypedValue(fieldOp.get()
                                , nonNullValueList.get(1)).toArray(new IValue[]{}));


                        conditions = new Conditions(left).addAnd(right);

                    } else {
                        logger.warn("required value more then 2, fallback to ge");
                        conditions = new Conditions(new Condition(
                                isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null
                                , originField
                                , ConditionOperator.GREATER_THAN_EQUALS
                                , toTypedValue(fieldOp.get()
                                , nonNullValueList.get(0)).toArray(new IValue[]{})));
                    }
                    break;
                case le:
                    conditions = new Conditions(new Condition(
                            isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null
                            , originField
                            , ConditionOperator.LESS_THAN_EQUALS
                            , toTypedValue(fieldOp.get()
                            , nonNullValueList.get(0)).toArray(new IValue[]{})));
                    break;
                case lt:
                    conditions = new Conditions(new Condition(
                            isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null
                            , originField
                            , ConditionOperator.LESS_THAN
                            , toTypedValue(fieldOp.get()
                            , nonNullValueList.get(0)).toArray(new IValue[]{})));
                    break;
                case in:
                    conditions = new Conditions(
                            new Condition(
                                    isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null
                                    , originField
                                    , ConditionOperator.MULTIPLE_EQUALS
                                    , nonNullValueList.stream().flatMap(x -> toTypedValue(fieldOp.get(), x).stream())
                                    .toArray(IValue[]::new)
                            )
                    );
                    break;
                case ni:
                    if (nonNullValueList.size() == 1) {
                        conditions = new Conditions(new Condition(
                                isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null
                                , originField
                                , ConditionOperator.NOT_EQUALS
                                , toTypedValue(fieldOp.get()
                                , nonNullValueList.get(0)).toArray(new IValue[]{})));
                    } else {
                        conditions = new Conditions(new Condition(
                                isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null
                                , originField
                                , ConditionOperator.NOT_EQUALS
                                , toTypedValue(fieldOp.get()
                                , nonNullValueList.get(0)).toArray(new IValue[]{})));

                        Conditions finalConditions = conditions;
                        nonNullValueList.stream().skip(1).forEach(x -> {
                            finalConditions.addAnd(new Conditions(new Condition(
                                    isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null
                                    , originField
                                    , ConditionOperator.NOT_EQUALS
                                    , toTypedValue(fieldOp.get()
                                    , x).toArray(new IValue[]{}))), false);
                        });

                        conditions = finalConditions;
                    }
                    break;
                case like:
                    conditions = new Conditions(new Condition(
                            isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null
                            , originField
                            , ConditionOperator.LIKE
                            , toTypedValue(fieldOp.get()
                            , nonNullValueList.get(0)).toArray(new IValue[]{})));
                    break;
                default:

            }
        }

        if (conditions == null) {
            throw new RuntimeException("Condition is invalid " + fieldCondition);
        }

        return conditions;
    }
}
