/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.autoconfigurer;

import akka.actor.ActorRefFactory;
import akka.actor.ActorSystem;
import akka.stream.ActorMaterializer;
import com.xforceplus.ultraman.metadata.grpc.CheckServiceClient;
import com.xforceplus.ultraman.oqsengine.sdk.EntityServiceClient;
import com.xforceplus.ultraman.oqsengine.sdk.autoconfigurer.configuration.GatewayUrlSupplier;
import com.xforceplus.ultraman.oqsengine.sdk.autoconfigurer.configuration.MessageAppIdSupplier;
import com.xforceplus.ultraman.oqsengine.sdk.autoconfigurer.configuration.MessageTokenSupplier;
import com.xforceplus.ultraman.oqsengine.sdk.config.AuthSearcherConfig;
import com.xforceplus.ultraman.oqsengine.sdk.config.init.DictInitService;
import com.xforceplus.ultraman.oqsengine.sdk.config.init.ModuleInitService;
import com.xforceplus.ultraman.oqsengine.sdk.config.init.NodeReporterInitService;
import com.xforceplus.ultraman.oqsengine.sdk.config.init.UltFormInitService;
import com.xforceplus.ultraman.oqsengine.sdk.config.init.UltPageInitService;
import com.xforceplus.ultraman.oqsengine.sdk.config.perm.page.PagePermissionClient;
import com.xforceplus.ultraman.oqsengine.sdk.controller.DownloadController;
import com.xforceplus.ultraman.oqsengine.sdk.handler.DefaultEntityServiceHandler;
import com.xforceplus.ultraman.oqsengine.sdk.interceptor.CodeExtendedInterceptor;
import com.xforceplus.ultraman.oqsengine.sdk.interceptor.ContextInterceptor;
import com.xforceplus.ultraman.oqsengine.sdk.interceptor.DefaultSearchInterceptor;
import com.xforceplus.ultraman.oqsengine.sdk.interceptor.MatchRouter;
import com.xforceplus.ultraman.oqsengine.sdk.interceptor.VersionInterceptor;
import com.xforceplus.ultraman.oqsengine.sdk.listener.ExportEventLoggerListener;
import com.xforceplus.ultraman.oqsengine.sdk.listener.MessageCenterEntityExportEventListener;
import com.xforceplus.ultraman.oqsengine.sdk.listener.ModuleEventListener;
import com.xforceplus.ultraman.oqsengine.sdk.query.transformer.ExpTreeTransformer;
import com.xforceplus.ultraman.oqsengine.sdk.query.transformer.QueryValueHandlerTransformer;
import com.xforceplus.ultraman.oqsengine.sdk.query.transformer.optimizer.CalciteConditionOptimizer;
import com.xforceplus.ultraman.oqsengine.sdk.query.transformer.optimizer.EmptyConditionRemover;
import com.xforceplus.ultraman.oqsengine.sdk.query.transformer.optimizer.IEntityClassSchema;
import com.xforceplus.ultraman.oqsengine.sdk.query.transformer.optimizer.planner.ExtractCommonToAndRules;
import com.xforceplus.ultraman.oqsengine.sdk.query.validate.ExpRangeValidator;
import com.xforceplus.ultraman.oqsengine.sdk.query.validate.ExpTreeValidator;
import com.xforceplus.ultraman.oqsengine.sdk.query.validate.ExpTreeValidatorImpl;
import com.xforceplus.ultraman.oqsengine.sdk.service.EntityService;
import com.xforceplus.ultraman.oqsengine.sdk.service.EntityServiceEx;
import com.xforceplus.ultraman.oqsengine.sdk.service.ExecutionService;
import com.xforceplus.ultraman.oqsengine.sdk.service.HandleQueryValueService;
import com.xforceplus.ultraman.oqsengine.sdk.service.HandleResultValueService;
import com.xforceplus.ultraman.oqsengine.sdk.service.HandleValueService;
import com.xforceplus.ultraman.oqsengine.sdk.service.PagePermissionService;
import com.xforceplus.ultraman.oqsengine.sdk.service.PlainEntityService;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.EntityExportService;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportRecordStringFlow;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportSink;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportSource;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportStringTransformer;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.impl.CSVRecordFlow;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.impl.DefaultExportCustomFieldToString;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.impl.EntityExportServiceImpl;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.impl.ExportStringTransformerImpl;
import com.xforceplus.ultraman.oqsengine.sdk.service.impl.DefaultHandleQueryValueService;
import com.xforceplus.ultraman.oqsengine.sdk.service.impl.DefaultHandleResultValueService;
import com.xforceplus.ultraman.oqsengine.sdk.service.impl.DefaultHandleValueService;
import com.xforceplus.ultraman.oqsengine.sdk.service.impl.EntityServiceExImpl;
import com.xforceplus.ultraman.oqsengine.sdk.service.impl.EntityServiceImpl;
import com.xforceplus.ultraman.oqsengine.sdk.service.impl.ExecutionServiceImpl;
import com.xforceplus.ultraman.oqsengine.sdk.service.impl.LocalFileExportSink;
import com.xforceplus.ultraman.oqsengine.sdk.service.impl.PagePermissionServiceImpl;
import com.xforceplus.ultraman.oqsengine.sdk.service.impl.PlainEntityServiceImpl;
import com.xforceplus.ultraman.oqsengine.sdk.service.impl.SequenceExportSource;
import com.xforceplus.ultraman.oqsengine.sdk.service.operation.AnotherSimpleExpressionFieldOperationHandler;
import com.xforceplus.ultraman.oqsengine.sdk.service.operation.BooleanFieldOperationHandler;
import com.xforceplus.ultraman.oqsengine.sdk.service.operation.DefaultFieldOperationHandler;
import com.xforceplus.ultraman.oqsengine.sdk.service.operation.DefaultFieldValueOperationHandler;
import com.xforceplus.ultraman.oqsengine.sdk.service.operation.FieldOperationHandler;
import com.xforceplus.ultraman.oqsengine.sdk.service.operation.FixedDefaultSystemOperationHandler;
import com.xforceplus.ultraman.oqsengine.sdk.service.operation.IdAppenderRecordOperationHandler;
import com.xforceplus.ultraman.oqsengine.sdk.service.operation.QuerySideFieldOperationHandler;
import com.xforceplus.ultraman.oqsengine.sdk.service.operation.RecordOperationHandler;
import com.xforceplus.ultraman.oqsengine.sdk.service.operation.ResultSideOperationHandler;
import com.xforceplus.ultraman.oqsengine.sdk.service.operation.SimpleExpressionFieldOperationHandler;
import com.xforceplus.ultraman.oqsengine.sdk.service.operation.validator.FieldValidator;
import com.xforceplus.ultraman.oqsengine.sdk.service.operation.validator.RegxValidator;
import com.xforceplus.ultraman.oqsengine.sdk.service.operation.validator.RequiredValidator;
import com.xforceplus.ultraman.oqsengine.sdk.service.operation.validator.TypeCheckValidator;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.CurrentUpdateService;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.DictMapLocalStore;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.FormBoMapLocalStore;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.MetadataRepository;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.PageBoMapLocalStore;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.impl.CurrentUpdateServiceImpl;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.impl.MetadataRepositoryInMemoryImpl;
import com.xforceplus.ultraman.oqsengine.sdk.util.flow.FlowRegistry;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionQueryRequest;
import com.xforceplus.xplat.galaxy.framework.context.ContextService;
import com.xforceplus.xplat.galaxy.framework.dispatcher.interceptor.MessageDispatcherInterceptor;
import com.xforceplus.xplat.galaxy.grpc.spring.EnableGrpcServiceClients;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.github.resilience4j.retry.RetryRegistry;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.RelBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;

@ConditionalOnProperty(value={"xplat.oqsengine.sdk.enabled"}, matchIfMissing=true)
@AutoConfigureOrder
@EnableGrpcServiceClients(basePackages={"com.xforceplus.ultraman.metadata.grpc", "com.xforceplus.ultraman.oqsengine.sdk"})
public class InitServiceAutoConfiguration {
    @Autowired
    private AuthSearcherConfig config;

    @Bean(destroyMethod="terminate")
    @ConditionalOnMissingBean(value={ActorSystem.class})
    public ActorSystem actorSystem() {
        return ActorSystem.create((String)"grpc-server");
    }

    @Bean(destroyMethod="shutdown")
    @ConditionalOnMissingBean(value={ActorMaterializer.class})
    public ActorMaterializer mat(ActorSystem system) {
        return ActorMaterializer.create((ActorRefFactory)system);
    }

    @Bean(value={"dictLocalStore"})
    public DictMapLocalStore dictLocalStore() {
        return DictMapLocalStore.create();
    }

    @Bean(value={"pageBoMapLocalStore"})
    public PageBoMapLocalStore pageBoLocalStore() {
        return PageBoMapLocalStore.create();
    }

    @Bean(value={"formBoMapLocalStore"})
    public FormBoMapLocalStore formBoLocalStore() {
        return FormBoMapLocalStore.create();
    }

    @ConditionalOnProperty(value={"xplat.oqsengine.sdk.meta.enabled"}, matchIfMissing=true)
    @Bean
    public DictInitService dictInitService() {
        return new DictInitService();
    }

    @ConditionalOnProperty(value={"xplat.oqsengine.sdk.meta.enabled"}, matchIfMissing=true)
    @Bean
    public ModuleInitService moduleInitService(CheckServiceClient checkServiceClient, ActorMaterializer mat, AuthSearcherConfig config, ApplicationEventPublisher publisher) {
        return new ModuleInitService(checkServiceClient, mat, config, publisher);
    }

    @ConditionalOnProperty(value={"xplat.oqsengine.sdk.meta.enabled"}, matchIfMissing=true)
    @Bean
    public NodeReporterInitService nodeReporterInitService() {
        return new NodeReporterInitService();
    }

    @Bean
    public DefaultEntityServiceHandler entityServiceHandler() {
        return new DefaultEntityServiceHandler();
    }

    @Bean
    public static PropertySourcesPlaceholderConfigurer propertyConfigInDev() {
        return new PropertySourcesPlaceholderConfigurer();
    }

    @ConditionalOnMissingBean(value={MetadataRepository.class})
    @Bean
    public MetadataRepository metadataRepository(@Value(value="${xplat.oqsengine.sdk.max-version:3}") Integer versionSize, ApplicationEventPublisher publisher) {
        return new MetadataRepositoryInMemoryImpl(versionSize, publisher);
    }

    @Bean
    public EntityService entityService(MetadataRepository metadataRepository, EntityServiceClient entityServiceClient, ContextService contextService) {
        return new EntityServiceImpl(metadataRepository, entityServiceClient, contextService);
    }

    @Bean
    public PlainEntityService plainEntityService(EntityService entityService) {
        return new PlainEntityServiceImpl(entityService);
    }

    @Bean
    public EntityServiceEx entityServiceEx(MetadataRepository metadataRepository, EntityServiceClient entityServiceClient, ContextService contextService) {
        return new EntityServiceExImpl(contextService, entityServiceClient);
    }

    @Bean
    public DefaultExportCustomFieldToString defaultExportCustomFieldToString() {
        return new DefaultExportCustomFieldToString();
    }

    @Bean
    public ExportStringTransformer stringTransformer() {
        return new ExportStringTransformerImpl();
    }

    @Bean
    public DefaultEntityServiceHandler defaultEntityServiceHandler() {
        return new DefaultEntityServiceHandler();
    }

    @Bean
    public RestTemplate restTemplate(RestTemplateBuilder builder) {
        List converters = builder.build().getMessageConverters();
        for (HttpMessageConverter converter : converters) {
            if (!(converter instanceof MappingJackson2HttpMessageConverter)) continue;
            try {
                ArrayList<MediaType> mediaTypeList = new ArrayList<MediaType>(converter.getSupportedMediaTypes());
                mediaTypeList.add(MediaType.APPLICATION_JSON);
                ((MappingJackson2HttpMessageConverter)converter).setSupportedMediaTypes(mediaTypeList);
            }
            catch (Exception exception) {}
        }
        return builder.build();
    }

    @Bean
    public ClientHttpRequestFactory simpleClientHttpRequestFactory() {
        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
        factory.setReadTimeout(5000);
        factory.setConnectTimeout(5000);
        return factory;
    }

    @Bean
    public MessageDispatcherInterceptor<?> codeExtendInterceptor(MetadataRepository metadataRepository) {
        return new CodeExtendedInterceptor(metadataRepository);
    }

    @Bean
    public MessageDispatcherInterceptor<?> contextAwareInterceptor(ContextService contextService) {
        return new ContextInterceptor(contextService);
    }

    @ConditionalOnBean(name={"searchCondition"}, value={MatchRouter.class})
    @Bean
    public MessageDispatcherInterceptor<?> DefaultSearchInterceptor(MatchRouter<String, ConditionQueryRequest> matchRouter) {
        return new DefaultSearchInterceptor(matchRouter);
    }

    @Bean
    public FieldValidator regex() {
        return new RegxValidator();
    }

    @Bean
    public FieldValidator required() {
        return new RequiredValidator();
    }

    @Bean
    public FieldValidator typedCheck() {
        return new TypeCheckValidator();
    }

    @Bean
    public FieldOperationHandler defaultField() {
        return new DefaultFieldOperationHandler();
    }

    @Bean
    public FieldOperationHandler defaultValueField() {
        return new DefaultFieldValueOperationHandler();
    }

    @Bean
    public FieldOperationHandler defaultSystemField(ContextService contextService, @Value(value="${xplat.oqsengine.sdk.override:false}") Boolean isOverride) {
        return new FixedDefaultSystemOperationHandler(contextService, isOverride);
    }

    @Bean
    public FieldOperationHandler simpleExpressionFieldOperationHandler(ContextService contextService) {
        return new SimpleExpressionFieldOperationHandler(contextService);
    }

    @Bean
    public FieldOperationHandler anotherSimpleExpressionFieldOperationHandler(ContextService contextService) {
        return new AnotherSimpleExpressionFieldOperationHandler(contextService);
    }

    @Bean
    public HandleValueService defaultHandleValueService(List<FieldOperationHandler> fieldOperationHandlers, List<FieldValidator<Object>> fieldValidators) {
        return new DefaultHandleValueService(fieldOperationHandlers, fieldValidators);
    }

    @Bean
    public HandleQueryValueService defaultHandleQueryValueService(List<QuerySideFieldOperationHandler> querySideFieldOperationHandler) {
        return new DefaultHandleQueryValueService(querySideFieldOperationHandler);
    }

    @Bean
    public HandleResultValueService defaultHandleResultValueService(List<RecordOperationHandler> handlers, List<ResultSideOperationHandler> resultSideOperationHandlers) {
        return new DefaultHandleResultValueService(handlers, resultSideOperationHandlers);
    }

    @Bean
    public ResultSideOperationHandler booleanTyped() {
        return new BooleanFieldOperationHandler();
    }

    @Bean
    public RecordOperationHandler idAppend() {
        return new IdAppenderRecordOperationHandler();
    }

    @Bean
    public UltFormInitService ultFormInitService() {
        return new UltFormInitService();
    }

    @Bean
    public UltPageInitService ultPageInitService() {
        return new UltPageInitService();
    }

    @Bean
    public ModuleEventListener listener() {
        return new ModuleEventListener();
    }

    @ConditionalOnMissingBean(value={ExportSource.class})
    @Bean
    public ExportSource exportSource(EntityService entityService, ExecutionService executionService, @Value(value="${xplat.oqsengine.sdk.export.step:500}") int step, ContextService contextService) {
        return new SequenceExportSource(entityService, step, contextService, executionService);
    }

    @ConditionalOnMissingBean(value={ExportRecordStringFlow.class})
    @Bean
    public ExportRecordStringFlow Exportflow() {
        return new CSVRecordFlow();
    }

    @ConditionalOnMissingBean(value={ExportSink.class})
    @ConditionalOnProperty(value={"xplat.oqsengine.sdk.export.local-sink"}, matchIfMissing=true)
    @Bean
    public ExportSink localFileSink(@Value(value="${xplat.oqsengine.sdk.export.local.root:/}") String root) {
        return new LocalFileExportSink(root);
    }

    @ConditionalOnProperty(value={"xplat.oqsengine.sdk.stopverisoned"}, matchIfMissing=true)
    @Bean
    public MessageDispatcherInterceptor<?> clearVersion() {
        return new VersionInterceptor();
    }

    @ConditionalOnBean(value={MessageAppIdSupplier.class, MessageTokenSupplier.class, GatewayUrlSupplier.class, RestTemplate.class})
    @ConditionalOnProperty(value={"xplat.oqsengine.sdk.export.message.enabled"}, matchIfMissing=true)
    @Bean
    public MessageCenterEntityExportEventListener exportEventListener(MessageTokenSupplier tokenSupplier, MessageAppIdSupplier appIdSupplier, GatewayUrlSupplier gatewayUrlSupplier, @Value(value="${xplat.oqsengine.sdk.export.message.template.content:#{null}}") String content, @Value(value="${xplat.oqsengine.sdk.export.message.template.title:#{null}}") String title, @Value(value="${xplat.oqsengine.sdk.export.message.context-path:}") String contextPath, @Value(value="${xplat.oqsengine.sdk.export.message.ignore-on-sync:true}") boolean ignoreOnSync, RestTemplate restTemplate) {
        return new MessageCenterEntityExportEventListener(tokenSupplier::getToken, appIdSupplier::getStorageAppId, gatewayUrlSupplier::getGatewayUrl, content, title, restTemplate, contextPath, ignoreOnSync);
    }

    @ConditionalOnBean(value={ExportSink.class})
    @ConditionalOnProperty(value={"xplat.oqsengine.sdk.export.local.download"}, matchIfMissing=true)
    @Bean
    public DownloadController downloadController(ExportSink exportSink) {
        return new DownloadController(exportSink);
    }

    @ConditionalOnProperty(value={"xplat.oqsengine.sdk.export.log"}, matchIfMissing=true)
    @Bean
    public ExportEventLoggerListener loggerListener() {
        return new ExportEventLoggerListener();
    }

    @Bean
    public RetryRegistry retryRegistry() {
        return RetryRegistry.ofDefaults();
    }

    @Bean
    public RateLimiterRegistry rateLimiterRegistry() {
        return RateLimiterRegistry.ofDefaults();
    }

    @Bean
    public FlowRegistry flowRegistry(ActorMaterializer mat) {
        return new FlowRegistry(mat);
    }

    @Bean
    public RateLimiter rateLimiter(RateLimiterRegistry registry) {
        RateLimiterConfig config = RateLimiterConfig.custom().limitRefreshPeriod(Duration.ofMillis(10L)).limitForPeriod(10).timeoutDuration(Duration.ofMillis(25L)).build();
        RateLimiter rateLimiter = registry.rateLimiter("retry", config);
        return rateLimiter;
    }

    @ConditionalOnMissingBean(value={EntityExportService.class})
    @Bean
    public EntityExportService entityExportService() {
        return new EntityExportServiceImpl();
    }

    @Bean
    public ExecutionService executionService() {
        return new ExecutionServiceImpl();
    }

    @Bean
    public QueryValueHandlerTransformer queryValueHandlerTransformer(List<QuerySideFieldOperationHandler> querySideFieldOperationHandler) {
        return new QueryValueHandlerTransformer(querySideFieldOperationHandler);
    }

    @Bean
    public ExpTreeValidator expTreeValidator(List<FieldValidator<Object>> fieldValidators) {
        return new ExpTreeValidatorImpl(fieldValidators);
    }

    @Bean
    public ExpTreeValidator rangeValidator(@Value(value="${xplat.oqsengine.sdk.strict.range:true}") boolean isStrict) {
        return new ExpRangeValidator(isStrict);
    }

    @Bean
    public PagePermissionClient permissionClient() {
        return new PagePermissionClient();
    }

    @Bean
    public PagePermissionService permissionService() {
        return new PagePermissionServiceImpl();
    }

    @Bean
    public ExpTreeTransformer optimizer() {
        return new CalciteConditionOptimizer();
    }

    @Bean
    public ExpTreeTransformer emptyOptimizer() {
        return new EmptyConditionRemover();
    }

    @Bean
    public RelOptRule removeOr() {
        return new ExtractCommonToAndRules();
    }

    @Bean
    public CurrentUpdateService currentUpdateService() {
        return new CurrentUpdateServiceImpl();
    }

    @Bean
    public FrameworkConfig relBuilder(MetadataRepository repository, AuthSearcherConfig authSearcherConfig) {
        SchemaPlus rootSchema = CalciteSchema.createRootSchema((boolean)true, (boolean)false).plus();
        FrameworkConfig config = Frameworks.newConfigBuilder().defaultSchema(rootSchema.add("main", (Schema)new IEntityClassSchema(repository, authSearcherConfig))).build();
        RelBuilder relBuilder = RelBuilder.create((FrameworkConfig)config);
        return config;
    }
}

